/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.history.impl;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javers.core.metamodel.object.SnapshotType;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.history.JaversCommitPropertyRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.history.JaversCommitRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.history.JaversGlobalIdRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.history.JaversSnapshotRepository;
import org.qubership.atp.itf.lite.backend.model.api.response.history.JaversCountResponse;
import org.qubership.atp.itf.lite.backend.model.entities.javers.history.JvGlobalIdEntity;
import org.qubership.atp.itf.lite.backend.model.entities.javers.history.JvSnapshotEntity;
import org.qubership.atp.itf.lite.backend.service.history.iface.DeleteHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeleteHistoryServiceImpl
implements DeleteHistoryService {
    private static final Logger log = LoggerFactory.getLogger(DeleteHistoryServiceImpl.class);
    private static final Integer FIRST_PAGE = 0;
    private final JaversSnapshotRepository snapshotRepository;
    private final JaversGlobalIdRepository globalIdRepository;
    private final JaversCommitRepository commitRepository;
    private final JaversCommitPropertyRepository commitPropertyRepository;

    @Transactional(rollbackFor={Exception.class})
    public void deleteOldAndUpdateAsInitial(Long globalId, List<JvSnapshotEntity> snapshots) {
        snapshots.forEach(snapshot -> this.deleteOldSnapshot(globalId, (JvSnapshotEntity)snapshot));
        this.findTheOldestSnapshotByGlobalIdAndUpdateTypeAsInitial(globalId);
    }

    private void deleteOldSnapshot(Long globalId, JvSnapshotEntity snapshot) {
        Long commitId = snapshot.getCommitId();
        Long version = snapshot.getVersion();
        this.snapshotRepository.deleteByVersionAndGlobalIdAndCommitId(version, globalId, commitId);
        log.debug("Deleted snapshots with version '{}', globalId '{}', commitId '{}'", new Object[]{version, globalId, commitId});
        Long commitCount = this.snapshotRepository.countByCommitId(commitId);
        if (commitCount.equals(0L)) {
            this.commitPropertyRepository.deleteByIdCommitId(commitId);
            this.commitRepository.deleteById(commitId);
            log.debug("Deleted commit properties and commits with commitId '{}'", (Object)commitId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOldSnapshots(long maxRevisionCount) {
        this.findGlobalIdAndCount(maxRevisionCount).forEach(response -> {
            Long globalId = response.getId();
            long numberOfOldSnapshots = response.getCount() - maxRevisionCount;
            List<JvSnapshotEntity> oldSnapshots = this.findOldSnapshots(globalId, numberOfOldSnapshots);
            this.deleteOldAndUpdateAsInitial(globalId, oldSnapshots);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTerminatedSnapshots(Integer pageSize) {
        Page<JvSnapshotEntity> page;
        do {
            page = this.snapshotRepository.findAllByTypeIs(SnapshotType.TERMINAL, (Pageable)PageRequest.of((int)FIRST_PAGE, (int)pageSize));
            this.deleteTerminatedSnapshots(page);
        } while (page.hasNext());
    }

    private void deleteTerminatedSnapshots(Page<JvSnapshotEntity> page) {
        List terminalSnapshots = page.getContent();
        Set<Long> globalIds = this.getIds(terminalSnapshots, JvSnapshotEntity::getGlobalId);
        log.debug("Number of terminal globalIds '{}'", (Object)globalIds.size());
        ArrayList snapshots = new ArrayList();
        this.doAction(globalIds, ids -> snapshots.addAll(this.snapshotRepository.findAllByGlobalIdIn((Collection<Long>)ids)));
        Set<Long> commitIds = this.getIds(snapshots, JvSnapshotEntity::getCommitId);
        log.debug("Number of terminal commitIds '{}'", (Object)commitIds.size());
        this.doAction(globalIds, this.snapshotRepository::deleteByGlobalIdIn);
        log.debug("Terminated snapshots deleted");
        this.doAction(globalIds, this.globalIdRepository::deleteByIdIn);
        log.debug("Terminated globalIds deleted");
        this.doAction(commitIds, this.commitPropertyRepository::deleteByIdCommitIdIn);
        log.debug("Terminated commit properties deleted");
        this.doAction(commitIds, this.commitRepository::deleteByIdIn);
        log.debug("Terminated commits deleted");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSnapshotsByEntityIds(Set<UUID> entityIds) {
        List<JvGlobalIdEntity> globalIdEntities = this.globalIdRepository.findAllByEntityIds(entityIds.stream().map(entityId -> "\"" + entityId.toString() + "\"").collect(Collectors.toSet()));
        Set globalIds = globalIdEntities.stream().map(JvGlobalIdEntity::getId).collect(Collectors.toSet());
        log.debug("Number of globalIds '{}' for entityIds: {}", (Object)globalIdEntities.size(), entityIds);
        ArrayList snapshots = new ArrayList();
        this.doAction(globalIds, ids -> snapshots.addAll(this.snapshotRepository.findAllByGlobalIdIn((Collection<Long>)ids)));
        Set<Long> commitIds = this.getIds(snapshots, JvSnapshotEntity::getCommitId);
        log.debug("Number of commitIds '{}' for entityIds: {}", (Object)commitIds.size(), entityIds);
        this.doAction(globalIds, this.snapshotRepository::deleteByGlobalIdIn);
        log.debug("Snapshots deleted for entityIds: {}", entityIds);
        this.doAction(commitIds, this.snapshotRepository::deleteByCommitIdIn);
        log.debug("Snapshots deleted for commitIds: {}", commitIds);
        this.doAction(globalIds, this.globalIdRepository::deleteByIdIn);
        log.debug("GlobalIds deleted for entityIds: {}", entityIds);
        this.doAction(commitIds, this.commitPropertyRepository::deleteByIdCommitIdIn);
        log.debug("Commit properties deleted for entityIds: {}", entityIds);
        this.doAction(commitIds, this.commitRepository::deleteByIdIn);
        log.debug("Commits deleted for entityIds: {}", entityIds);
    }

    private JvSnapshotEntity findTheOldestSnapshotByGlobalIdAndUpdateTypeAsInitial(Long globalId) {
        JvSnapshotEntity snapshot = this.snapshotRepository.findFirstByGlobalIdOrderByVersionAsc(globalId);
        if (Objects.isNull(snapshot)) {
            return null;
        }
        snapshot.setType(SnapshotType.INITIAL);
        return (JvSnapshotEntity)this.snapshotRepository.save(snapshot);
    }

    private List<JvSnapshotEntity> findOldSnapshots(Long globalId, Long count) {
        PageRequest pageRequest = PageRequest.of((int)0, (int)Math.toIntExact(count));
        List<JvSnapshotEntity> oldSnapshots = this.snapshotRepository.findAllByGlobalIdOrderByVersionAsc(globalId, (Pageable)pageRequest);
        log.debug("Number of old snapshots '{}' for globalId '{}'", (Object)oldSnapshots.size(), (Object)globalId);
        return oldSnapshots;
    }

    private List<JaversCountResponse> findGlobalIdAndCount(long maxRevisionCount) {
        List<JaversCountResponse> response = this.snapshotRepository.findGlobalIdAndCountGreaterThan(maxRevisionCount);
        log.debug("Number of unique globalId '{}'", (Object)response.size());
        return response;
    }

    private <T> void doAction(Collection<T> collection, Consumer<? super List<T>> action) {
        Iterators.partition(collection.iterator(), (int)100).forEachRemaining(action);
    }

    private <T, R> Set<R> getIds(List<T> snapshots, Function<T, R> function) {
        return snapshots.stream().map(function).collect(Collectors.toSet());
    }

    public DeleteHistoryServiceImpl(JaversSnapshotRepository snapshotRepository, JaversGlobalIdRepository globalIdRepository, JaversCommitRepository commitRepository, JaversCommitPropertyRepository commitPropertyRepository) {
        this.snapshotRepository = snapshotRepository;
        this.globalIdRepository = globalIdRepository;
        this.commitRepository = commitRepository;
        this.commitPropertyRepository = commitPropertyRepository;
    }
}

