/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.history.impl;

import org.javers.core.Javers;
import org.javers.shadow.Shadow;
import org.qubership.atp.itf.lite.backend.converters.history.FolderVersioningMapper;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FolderRepository;
import org.qubership.atp.itf.lite.backend.feign.dto.history.CompareEntityResponseDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.FolderHistoryChangeDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HistoryItemTypeDto;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.service.history.impl.AbstractRetrieveHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FolderRetrieveHistoryService
extends AbstractRetrieveHistoryService {
    private static final Logger log = LoggerFactory.getLogger(FolderRetrieveHistoryService.class);
    private final FolderRepository folderRepository;

    @Autowired
    public FolderRetrieveHistoryService(Javers javers, FolderVersioningMapper mapping, FolderRepository folderRepository) {
        super(javers, mapping);
        this.folderRepository = folderRepository;
    }

    public Class<Folder> getEntityClass() {
        return Folder.class;
    }

    @Override
    public HistoryItemTypeDto getItemType() {
        return HistoryItemTypeDto.FOLDER;
    }

    public FolderVersioningMapper getMapper() {
        return (FolderVersioningMapper)this.abstractVersioningMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompareEntityResponseDto buildCompareEntity(String revision, Shadow<Object> entity) {
        FolderHistoryChangeDto resolvedEntity;
        Folder folder;
        block3: {
            block2: {
                log.debug("version={}, entity={}", (Object)revision, entity);
                folder = (Folder)entity.get();
                resolvedEntity = (FolderHistoryChangeDto)this.getMapper().map(folder);
                if (folder.getParentId() == null) break block2;
                Folder parentFolder = null;
                try {
                    parentFolder = (Folder)this.folderRepository.getOne(folder.getParentId());
                    resolvedEntity.setParentFolder(parentFolder == null ? "Parent folder with ID #" + folder.getParentId() + " has been deleted" : parentFolder.getName());
                }
                catch (Throwable throwable) {
                    resolvedEntity.setParentFolder(parentFolder == null ? "Parent folder with ID #" + folder.getParentId() + " has been deleted" : parentFolder.getName());
                    throw throwable;
                }
                break block3;
            }
            resolvedEntity.setParentFolder("Root");
        }
        this.setCommonFields(folder, resolvedEntity, entity.getCommitMetadata());
        CompareEntityResponseDto compareEntityResponseDto = new CompareEntityResponseDto();
        compareEntityResponseDto.setRevision(revision);
        compareEntityResponseDto.setCompareEntity(resolvedEntity);
        return compareEntityResponseDto;
    }
}

