/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.kafka;

import java.util.UUID;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ItfLiteExecutionFinishEvent;
import org.qubership.atp.itf.lite.backend.service.SseEmitterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class KafkaExecutionFinishResponseService {
    private static final Logger log = LoggerFactory.getLogger(KafkaExecutionFinishResponseService.class);
    private static final String KAFKA_ITF_LITE_EXECUTION_FINISH_EVENT_RESPONSE_LISTENER_ID = "kafkaItfLiteExecutionFinishEventResponseListenerId";
    private final SseEmitterService sseEmitterService;

    public KafkaExecutionFinishResponseService(SseEmitterService sseEmitterService) {
        this.sseEmitterService = sseEmitterService;
    }

    @KafkaListener(groupId="kafkaItfLiteExecutionFinishEventResponseListenerId_#{T(org.qubership.atp.itf.lite.backend.utils.PodNameUtils).getServicePodName()}", topics={"${kafka.itflite.execution.finish.topic}"}, containerFactory="itfLiteExecutionFinishContainerFactory")
    @Transactional
    public void listenItfLiteExecutionFinishEvent(@Payload ItfLiteExecutionFinishEvent executionFinishEvent) {
        MDC.clear();
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)executionFinishEvent.getRequestId());
        log.debug("Start itf-lite execution processing by event from kafka [{}]", (Object)executionFinishEvent);
        SseEmitter sseEmitter = this.sseEmitterService.getEmitter(executionFinishEvent.getSseId());
        if (sseEmitter == null) {
            log.debug("Sse emitter with sseId = {} not found.", (Object)executionFinishEvent.getSseId());
            return;
        }
        this.sseEmitterService.generateResponseAndSendToEmitter(sseEmitter, executionFinishEvent);
    }
}

