/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.kafka;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ItfExportRequestEvent;
import org.qubership.atp.itf.lite.backend.model.api.kafka.MiaExportRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaExportEventSendingService {
    private static final Logger log = LoggerFactory.getLogger(KafkaExportEventSendingService.class);
    private String miaTopicName;
    private KafkaTemplate<UUID, MiaExportRequestEvent> miaExportKafkaTemplate;
    private String itfTopicName;
    private KafkaTemplate<UUID, ItfExportRequestEvent> itfExportKafkaTemplate;

    public KafkaExportEventSendingService(String miaTopicName, KafkaTemplate<UUID, MiaExportRequestEvent> miaExportKafkaTemplate, String itfTopicName, KafkaTemplate<UUID, ItfExportRequestEvent> itfExportKafkaTemplate) {
        this.miaTopicName = miaTopicName;
        this.miaExportKafkaTemplate = miaExportKafkaTemplate;
        this.itfTopicName = itfTopicName;
        this.itfExportKafkaTemplate = itfExportKafkaTemplate;
    }

    public void miaExportRequestEventSend(UUID requestExportId, MiaExportRequestEvent miaExportRequestEvent) {
        log.debug("Send mia export request to kafka for requestExportId = {}, requestId = {}", (Object)requestExportId, (Object)miaExportRequestEvent.getRequest().getId());
        this.miaExportKafkaTemplate.send(this.miaTopicName, (Object)requestExportId, (Object)miaExportRequestEvent);
    }

    public void itfExportRequestEventSend(UUID requestExportId, ItfExportRequestEvent itfExportRequestEvent) {
        log.debug("Send itf export request to kafka for requestExportId = {}, requestId = {}", (Object)requestExportId, (Object)itfExportRequestEvent.getRequest().getId());
        this.itfExportKafkaTemplate.send(this.itfTopicName, (Object)requestExportId, (Object)itfExportRequestEvent);
    }

    public KafkaExportEventSendingService() {
    }
}

