/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.kafka;

import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.components.auth.OAuth2RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.GetAuthorizationCodeRepository;
import org.qubership.atp.itf.lite.backend.exceptions.auth.AuthActionGetTokenByCodeException;
import org.qubership.atp.itf.lite.backend.exceptions.auth.AuthActionInvalidSseException;
import org.qubership.atp.itf.lite.backend.exceptions.auth.AuthActionInvalidStateException;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.model.api.kafka.GetAccessTokenFinish;
import org.qubership.atp.itf.lite.backend.model.api.response.auth.OAuth2AuthrizationResponse;
import org.qubership.atp.itf.lite.backend.model.api.sse.GetAccessTokenData;
import org.qubership.atp.itf.lite.backend.model.entities.auth.GetAuthorizationCode;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.service.SseEmitterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class KafkaGetAccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(KafkaGetAccessTokenService.class);
    private static final String KAFKA_ITF_LITE_GET_ACCESS_TOKEN_LISTENER_ID = "kafkaItfLiteGetAccessTokenListenerId";
    @Qualifier(value="getAccessTokenKafkaTemplate")
    private final KafkaTemplate<UUID, GetAccessTokenFinish> kafkaTemplate;
    private final SseEmitterService sseEmitterService;
    private final GetAuthorizationCodeRepository getAuthorizationCodeRepository;
    private final EncryptionService encryptionService;
    private final OAuth2RequestAuthorizationStrategy oauth2Strategy;
    @Value(value="${kafka.itflite.getaccesstoken.finish.topic}")
    public String finishTopic;

    public void getAccessTokenFinishEventSend(UUID sseId) {
        log.info("Send 'get access token' finish event for sseId #{}", (Object)sseId);
        this.kafkaTemplate.send(this.finishTopic, (Object)sseId, (Object)new GetAccessTokenFinish(sseId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KafkaListener(groupId="kafkaItfLiteGetAccessTokenListenerId_#{T(org.qubership.atp.itf.lite.backend.utils.PodNameUtils).getServicePodName()}", topics={"${kafka.itflite.getaccesstoken.finish.topic}"}, containerFactory="getAccessTokenContainerFactory")
    public void listenItfLiteGetAccessTokenFinishEvent(@Payload GetAccessTokenFinish getAccessTokenFinish) {
        UUID sseId = getAccessTokenFinish.getSseId();
        MDC.clear();
        MdcUtils.put((String)ItfLiteMdcField.SSE_ID.toString(), (UUID)sseId);
        log.debug("Start 'get access token' processing by event from kafka #{}", (Object)sseId);
        SseEmitter sseEmitter = this.sseEmitterService.getEmitter(sseId);
        if (sseEmitter == null) {
            log.debug("Sse emitter with sseId = {} not found.", (Object)sseId);
            return;
        }
        GetAuthorizationCode getAuthorizationCode = null;
        try {
            try {
                log.info("Start SSE ({}) processing by event from kafka", (Object)sseId);
                Optional getAuthorizationCodeOpt = this.getAuthorizationCodeRepository.findById(sseId);
                if (!getAuthorizationCodeOpt.isPresent()) {
                    ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionInvalidSseException(sseId));
                }
                if ((getAuthorizationCode = (GetAuthorizationCode)getAuthorizationCodeOpt.get()).getState() != null && !getAuthorizationCode.getState().equals(getAuthorizationCode.getResponseState())) {
                    ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionInvalidStateException(getAuthorizationCode.getState()));
                }
                GetAccessTokenData tokenResponse = new GetAccessTokenData(this.getAuthorizationToken(getAuthorizationCode));
                log.info("Received token ({}) from server. Send it into SSE", (Object)tokenResponse);
                this.sseEmitterService.sendGetAccessTokenResult(sseId, sseEmitter, tokenResponse);
            }
            catch (Exception e) {
                log.error("Failed processing by event from kafka", (Throwable)e);
                this.sseEmitterService.sendGetAccessTokenResult(sseId, sseEmitter, new GetAccessTokenData(e));
            }
            if (getAuthorizationCode == null) return;
        }
        catch (Throwable throwable) {
            if (getAuthorizationCode == null) throw throwable;
            this.getAuthorizationCodeRepository.delete(getAuthorizationCode);
            throw throwable;
        }
        this.getAuthorizationCodeRepository.delete(getAuthorizationCode);
    }

    private OAuth2AuthrizationResponse getAuthorizationToken(GetAuthorizationCode getAuthorizationCode) {
        log.info("Get authorization token  by code for sseID {}", (Object)getAuthorizationCode.getSseId());
        try {
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"grant_type", (Object)AuthorizationGrantType.AUTHORIZATION_CODE.getValue());
            params.add((Object)"code", (Object)this.encryptionService.decryptIfEncrypted(getAuthorizationCode.getAuthorizationCode()));
            params.add((Object)"client_id", (Object)getAuthorizationCode.getClientId());
            params.add((Object)"client_secret", (Object)this.encryptionService.decryptIfEncrypted(getAuthorizationCode.getClientSecret()));
            params.add((Object)"response_type", (Object)"token");
            params.add((Object)"redirect_uri", (Object)getAuthorizationCode.getRedirectUri());
            return this.oauth2Strategy.performAuthorization(getAuthorizationCode.getProjectId(), getAuthorizationCode.getAccessTokenUrl(), (MultiValueMap<String, String>)params);
        }
        catch (Exception e) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new AuthActionGetTokenByCodeException(e.getMessage()));
            return null;
        }
    }

    public KafkaGetAccessTokenService(KafkaTemplate<UUID, GetAccessTokenFinish> kafkaTemplate, SseEmitterService sseEmitterService, GetAuthorizationCodeRepository getAuthorizationCodeRepository, EncryptionService encryptionService, OAuth2RequestAuthorizationStrategy oauth2Strategy) {
        this.kafkaTemplate = kafkaTemplate;
        this.sseEmitterService = sseEmitterService;
        this.getAuthorizationCodeRepository = getAuthorizationCodeRepository;
        this.encryptionService = encryptionService;
        this.oauth2Strategy = oauth2Strategy;
    }
}

