/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.kafka.listeners;

import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.qubership.atp.integration.configuration.mdc.MdcField;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ProjectEvent;
import org.qubership.atp.itf.lite.backend.service.CertificateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class ProjectEventKafkaListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectEventKafkaListener.class);

    @Caching(evict={@CacheEvict(value={"projects"}, allEntries=true), @CacheEvict(value={"ATP_ITF_LITE_PROJECT_CERT"}, key="#event.projectId")})
    @KafkaListener(id="${kafka.catalog.notification.group}", groupId="${kafka.catalog.notification.group}", topics={"${kafka.catalog.notification.topic:catalog_notification_topic}"}, containerFactory="catalogProjectEventContainerFactory", autoStartup="true")
    public void listen(ProjectEvent event) {
        MDC.clear();
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)event.getProjectId());
        switch (event.getType()) {
            case CREATE: 
            case UPDATE: 
            case DELETE: {
                log.info("Received events from catalogue: " + event);
                File folder = new File(String.format(CertificateService.CERTIFICATE_FOLDER, event.getProjectId()));
                try {
                    FileUtils.cleanDirectory((File)folder);
                }
                catch (Exception e) {
                    log.error("Can't clean folder with certificates {} on event from kafka: {}", (Object)folder.getAbsoluteFile(), (Object)e.getMessage());
                }
                break;
            }
            default: {
                log.error("Unknown type of events from catalogue: " + (Object)((Object)event.getType()));
            }
        }
    }
}

