/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationResolvingContext;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.BasicAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.BearerAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.InheritFromParentAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.OAuth1AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.OAuth2AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.context.SaveRequestResolvingContext;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BasicRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BearerRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.InheritFromParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth2RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.qubership.atp.itf.lite.backend.service.TemplateResolverService;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationUtils {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationUtils.class);
    private static ObjectMapper objectMapper;
    private static TemplateResolverService templateResolverService;
    private static ModelMapper modelMapper;

    public static AuthorizationStrategyRequest createAuthStrategyRequest(AuthorizationSaveRequest authorization, Evaluator evaluator, SaveRequestResolvingContext resolvingContext, UUID projectId, UUID environmentId, String authUrl, HttpMethod httpMethod) throws JsonProcessingException {
        templateResolverService.resolveTemplatesWithOrder(authorization, resolvingContext, evaluator);
        AuthorizationSaveRequest safeAuthorization = (AuthorizationSaveRequest)objectMapper.readValue(objectMapper.writeValueAsString((Object)authorization), authorization.getClass());
        templateResolverService.processEncryptedValues(authorization, false);
        templateResolverService.processEncryptedValues(safeAuthorization, true);
        AuthorizationResolvingContext authResolvingContext = new AuthorizationResolvingContext(authUrl, httpMethod);
        return new AuthorizationStrategyRequest(safeAuthorization, authorization, authResolvingContext, projectId, environmentId, evaluator, resolvingContext);
    }

    public static AuthorizationSaveRequest castToAuthorizationSaveRequest(RequestAuthorization requestAuthorization) {
        return (AuthorizationSaveRequest)modelMapper.map((Object)requestAuthorization, AuthorizationUtils.getAuthorizationSaveRequestClassByAuthorizationRequest(requestAuthorization));
    }

    private static Class<? extends AuthorizationSaveRequest> getAuthorizationSaveRequestClassByAuthorizationRequest(RequestAuthorization authorization) {
        RequestAuthorizationType type = authorization.getType();
        switch (type) {
            case BEARER: {
                return BearerAuthorizationSaveRequest.class;
            }
            case OAUTH1: {
                return OAuth1AuthorizationSaveRequest.class;
            }
            case OAUTH2: {
                return OAuth2AuthorizationSaveRequest.class;
            }
            case INHERIT_FROM_PARENT: {
                return InheritFromParentAuthorizationSaveRequest.class;
            }
            case BASIC: {
                return BasicAuthorizationSaveRequest.class;
            }
        }
        log.error("Failed to get AuthorizationSaveRequest class by AuthorizationRequestType {}", (Object)type);
        throw new IllegalArgumentException("Failed to get AuthorizationSaveRequest class by AuthorizationRequestType");
    }

    public static Class<? extends RequestAuthorization> getRequestAuthorizationClassByAuthorizationSaveRequest(AuthorizationSaveRequest authorization) {
        RequestAuthorizationType type = authorization.getType();
        switch (type) {
            case BEARER: {
                return BearerRequestAuthorization.class;
            }
            case OAUTH2: {
                return OAuth2RequestAuthorization.class;
            }
            case INHERIT_FROM_PARENT: {
                return InheritFromParentRequestAuthorization.class;
            }
            case BASIC: {
                return BasicRequestAuthorization.class;
            }
        }
        log.error("Failed to get RequestAuthorization class by AuthorizationSaveRequest type {}", (Object)type);
        throw new IllegalArgumentException("Failed to get RequestAuthorization class by AuthorizationRequestType");
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        AuthorizationUtils.objectMapper = objectMapper;
    }

    public static void setTemplateResolverService(TemplateResolverService templateResolverService) {
        AuthorizationUtils.templateResolverService = templateResolverService;
    }

    public static void setModelMapper(ModelMapper modelMapper) {
        AuthorizationUtils.modelMapper = modelMapper;
    }
}

