/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.http.entity.ContentType;
import org.apache.tika.Tika;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final List<String> TEXT_CONTENT_TYPES = Arrays.asList(ContentType.DEFAULT_TEXT.getMimeType(), ContentType.TEXT_PLAIN.getMimeType(), ContentType.TEXT_HTML.getMimeType(), ContentType.TEXT_XML.getMimeType(), ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_ATOM_XML.getMimeType(), ContentType.APPLICATION_XML.getMimeType(), ContentType.APPLICATION_XHTML_XML.getMimeType(), ContentType.APPLICATION_SOAP_XML.getMimeType(), ContentType.MULTIPART_FORM_DATA.getMimeType());

    public static void deleteDirectoryRecursively(Path directory) throws IOException {
        log.debug("Clean all files and directories from {}", (Object)directory);
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    public static Path prepareDirectoriesBeforeSave(Path dictionariesFolder, UUID requestId) throws IOException {
        Path requestFolderPath = Paths.get(dictionariesFolder.toString(), requestId.toString());
        if (Files.exists(requestFolderPath, new LinkOption[0])) {
            FileUtils.deleteDirectoryRecursively(requestFolderPath);
        }
        Files.createDirectories(requestFolderPath, new FileAttribute[0]);
        return requestFolderPath;
    }

    public static void saveMultipartFileDictionaryToFileSystem(Path dictionariesFolder, UUID requestId, MultipartFile dictionary) throws IOException {
        Path requestFolderPath = FileUtils.prepareDirectoriesBeforeSave(dictionariesFolder, requestId);
        Path dictionaryFilePath = Paths.get(requestFolderPath.toString(), dictionary.getOriginalFilename());
        dictionary.transferTo(dictionaryFilePath);
    }

    public static void saveMultipartFileFormDataToFileSystem(Path formDataFolder, UUID requestId, MultipartFile file) throws IOException {
        Path requestFolderPath = FileUtils.prepareDirectoriesBeforeSave(formDataFolder, requestId);
        Path filePath = Paths.get(requestFolderPath.toString(), file.getOriginalFilename());
        file.transferTo(filePath);
    }

    public static Path saveFileDataDictionaryToFileSystem(Path dictionariesFolder, UUID requestId, FileData dictionaryFileData) throws IOException {
        Path requestFolderPath = FileUtils.prepareDirectoriesBeforeSave(dictionariesFolder, requestId);
        Path dictionaryFilePath = Paths.get(requestFolderPath.toString(), dictionaryFileData.getFileName());
        return Files.write(dictionaryFilePath, dictionaryFileData.getContent(), new OpenOption[0]);
    }

    public static String sanitizeFileName(String fileName) {
        Path p = Paths.get(fileName, new String[0]);
        return p.getFileName().toString();
    }

    public static Optional<String> readFileToString(MultipartFile file) throws IOException {
        String contentType = file.getContentType();
        if (contentType != null && TEXT_CONTENT_TYPES.contains(ContentType.parse((String)contentType).getMimeType())) {
            log.debug("Reading file with name '{}' and content type '{}'", (Object)file.getOriginalFilename(), (Object)contentType);
            return Optional.of(new String(file.getBytes()));
        }
        return Optional.empty();
    }

    public static ContentType guessContentTypeFromName(String fileName) {
        String mimeType = new Tika().detect(fileName);
        return ContentType.parse((String)mimeType);
    }
}

