/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.utils;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.itf.lite.backend.exceptions.ItfLiteException;
import org.qubership.atp.itf.lite.backend.model.api.Parameter;
import org.qubership.atp.itf.lite.backend.model.api.response.ErrorResponseSerializable;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);

    public static Request copyRequestFromRequest(Request requestToCopy) {
        HttpRequest newRequest = new HttpRequest();
        newRequest.setName(requestToCopy.getName());
        newRequest.setProjectId(requestToCopy.getProjectId());
        newRequest.setFolderId(requestToCopy.getFolderId());
        newRequest.setTransportType(requestToCopy.getTransportType());
        newRequest.setHttpMethod(((HttpRequest)requestToCopy).getHttpMethod());
        newRequest.setUrl(((HttpRequest)requestToCopy).getUrl());
        newRequest.setOrder(requestToCopy.getOrder());
        ArrayList<RequestHeader> headers = new ArrayList<RequestHeader>();
        List<RequestHeader> copyRequestHeaders = ((HttpRequest)requestToCopy).getRequestHeaders();
        if (!CollectionUtils.isEmpty(copyRequestHeaders)) {
            for (RequestHeader header : copyRequestHeaders) {
                headers.add(new RequestHeader(header));
            }
        }
        newRequest.setRequestHeaders(headers);
        ArrayList<RequestParam> params = new ArrayList<RequestParam>();
        List<RequestParam> copyRequestParam = ((HttpRequest)requestToCopy).getRequestParams();
        if (!CollectionUtils.isEmpty(copyRequestParam)) {
            for (RequestParam param : copyRequestParam) {
                params.add(new RequestParam(param));
            }
        }
        newRequest.setRequestParams(params);
        newRequest.setBody(RequestUtils.copyRequestBody(((HttpRequest)requestToCopy).getBody()));
        RequestAuthorization requestAuthorization = requestToCopy.getAuthorization();
        if (Objects.nonNull(requestAuthorization)) {
            newRequest.setAuthorization(requestAuthorization.copy());
        }
        newRequest.setPreScripts(requestToCopy.getPreScripts());
        newRequest.setPostScripts(requestToCopy.getPostScripts());
        newRequest.setDisableSslCertificateVerification(requestToCopy.isDisableSslCertificateVerification());
        newRequest.setDisableSslClientCertificate(requestToCopy.isDisableSslClientCertificate());
        newRequest.setDisableFollowingRedirect(requestToCopy.isDisableFollowingRedirect());
        newRequest.setAutoCookieDisabled(requestToCopy.isAutoCookieDisabled());
        return newRequest;
    }

    public static RequestBody copyRequestBody(RequestBody body) {
        RequestBody newBody = null;
        if (Objects.nonNull(body)) {
            newBody = new RequestBody(body.getContent(), body.getType());
            newBody.setQuery(body.getQuery());
            newBody.setVariables(body.getVariables());
            if (!CollectionUtils.isEmpty(body.getFormDataBody())) {
                ArrayList<FormDataPart> fdps = new ArrayList<FormDataPart>();
                body.getFormDataBody().forEach(fdp -> fdps.add(new FormDataPart((FormDataPart)fdp)));
                newBody.setFormDataBody(fdps);
            }
        }
        return newBody;
    }

    public static UriComponentsBuilder buildRequestWithParameters(String url, List<? extends Parameter> requestParams) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        if (!CollectionUtils.isEmpty(requestParams)) {
            requestParams.forEach(parameter -> {
                if (!parameter.isDisabled()) {
                    uriComponentsBuilder.queryParam(parameter.getKey(), new Object[]{parameter.getValue()});
                }
            });
        }
        return uriComponentsBuilder;
    }

    public static ErrorResponseSerializable getErrorResponse(Exception exception) {
        ResponseStatus responseStatus;
        if (exception == null) {
            return null;
        }
        if (!(exception instanceof AtpException)) {
            exception = new ItfLiteException(((Throwable)exception).getMessage());
        }
        HttpStatus status = (responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(exception.getClass(), ResponseStatus.class)) == null ? HttpStatus.INTERNAL_SERVER_ERROR : responseStatus.code();
        return ErrorResponseSerializable.serializableBuilder().status(status.value()).timestamp(new Date()).message(((Throwable)exception).getMessage()).reason(responseStatus == null ? "" : responseStatus.reason()).build();
    }

    public static double calculateHeadersSize(Header[] headers) {
        double size = 0.0;
        if (headers == null) {
            return size;
        }
        for (Header header : headers) {
            size += RequestUtils.calculateHeaderSize(header);
        }
        return size;
    }

    public static double calculateHeaderSize(Header header) {
        if (header == null) {
            return 0.0;
        }
        return header.getName().getBytes(StandardCharsets.UTF_8).length + header.getValue().getBytes(StandardCharsets.UTF_8).length;
    }
}

