/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.component;

import com.google.common.base.Strings;
import java.util.List;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlLoadDriverFailException;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.repo.driver.QueryDriver;
import org.springframework.stereotype.Component;

@Component
public class QueryDriverFactory {
    private final List<QueryDriver<?>> queryDrivers;

    public QueryDriver<?> getDriver(Server server) {
        String dbType = server.getProperty("db_type");
        QueryDriver<?> queryDriver = this.tryToGetDriver(dbType);
        if (queryDriver != null) {
            return queryDriver;
        }
        dbType = server.getProperty("jdbc_url");
        queryDriver = this.tryToGetDriver(dbType);
        if (queryDriver != null) {
            return queryDriver;
        }
        throw new SqlLoadDriverFailException(server.getProperty("jdbc_url"));
    }

    private QueryDriver<?> tryToGetDriver(String dbType) {
        if (!Strings.isNullOrEmpty((String)dbType)) {
            for (QueryDriver<?> queryDriver : this.queryDrivers) {
                if (!dbType.toLowerCase().contains(queryDriver.getDriverType().toLowerCase())) continue;
                return queryDriver;
            }
        }
        return null;
    }

    public QueryDriverFactory(List<QueryDriver<?>> queryDrivers) {
        this.queryDrivers = queryDrivers;
    }
}

