/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.config;

import org.qubership.atp.mia.service.cache.MiaCacheService;
import org.qubership.atp.mia.service.cache.MiaCacheServiceHazelCast;
import org.qubership.atp.mia.service.cache.MiaCacheServiceNoHazelCast;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
@Primary
public class CacheConfiguration {
    @Value(value="${spring.cache.hazelcast.client.enable:#{false}}")
    private boolean hazelcastClientEnabled;

    @Bean
    public CacheManager cacheManager(MiaCacheService miaCacheService) {
        return miaCacheService.cacheManager();
    }

    @Bean
    MiaCacheService getMiaCacheService() {
        if (this.hazelcastClientEnabled) {
            return new MiaCacheServiceHazelCast();
        }
        return new MiaCacheServiceNoHazelCast();
    }
}

