/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Indexes;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsCommandListener;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsConnectionPoolListener;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.types.ObjectId;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.repo.gridfs.GridFsRepository;
import org.qubership.atp.mia.repo.gridfs.GridFsRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MiaGridFsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MiaGridFsConfiguration.class);
    private final MeterRegistry meterRegistry;
    @Value(value="${gridfs.enable:false}")
    private String enable;
    @Value(value="${gridfs.database:#{null}}")
    private String database;
    @Value(value="${gridfs.host:#{null}}")
    private String host;
    @Value(value="${gridfs.port:#{null}}")
    private String port;
    @Value(value="${gridfs.username:#{null}}")
    private String user;
    @Value(value="${gridfs.password:#{null}}")
    private String password;

    @Bean
    public GridFsRepository provideRepo() {
        try {
            if (!this.enable.equals("true") || this.database == null || this.host == null) {
                log.info("Shutting down GridFS; isEnable {}, db {}, host {}", new Object[]{this.enable, this.database, this.host});
                throw new Exception();
            }
            GridFSBucket gridFsBucket = this.provideGridFileSystemBuckets(this.meterRegistry);
            log.info("Created gridFS bucket");
            return new GridFsRepositoryImpl(gridFsBucket);
        }
        catch (Exception e) {
            String message = "Can not initialize Grid FS module, will use mock instead";
            log.warn(message, (Throwable)e);
            return new GridFsRepository(){

                @Override
                public boolean isEnable() {
                    return false;
                }

                @Override
                public ObjectId save(FileMetaData fileData, InputStream fileInputStream) {
                    log.error("Can't save, it's only mock");
                    return ObjectId.get();
                }

                @Override
                public boolean exist(ProjectFile projectFile) {
                    return true;
                }

                @Override
                public void findAndDeleteObsoleteProjectFiles(UUID projectId, List<String> excludeIds) {
                }

                @Override
                public Optional<InputStream> get(FileMetaData fileData) {
                    log.error("Can't get, it's only mock");
                    return Optional.empty();
                }

                @Override
                public Optional<GridFSFile> getById(String gridFsObjectId) {
                    log.error("Can't get, it's only mock");
                    return Optional.empty();
                }

                @Override
                public void removeFile(FileMetaData fileData) {
                    log.error("Can't remove, it's only mock");
                }

                @Override
                public void removeFile(ObjectId objectId) {
                    log.error("Can't remove, it's only mock");
                }

                @Override
                public void rename(ProjectFile projectFile) {
                }

                @Override
                public String getCollectionsSize(UUID projectId) {
                    return "0";
                }

                @Override
                public void cleanDb() {
                }

                @Override
                public byte[] getFileContent(GridFSFile file) {
                    return new byte[0];
                }
            };
        }
    }

    private GridFSBucket provideGridFileSystemBuckets(MeterRegistry meterRegistry) {
        log.info("Creating gridFS bucket");
        String mongoClientUri = String.format("mongodb://%s%s:%s/%s", this.user.isEmpty() || this.password.isEmpty() ? "" : this.user + ":" + this.password + "@", this.host, this.port, this.database.isEmpty() ? "" : "?authSource=" + this.database);
        log.info("Mongo connection string: {}", (Object)mongoClientUri);
        ConnectionString connectionString = new ConnectionString(mongoClientUri);
        MongoClient mongo = MongoClients.create((MongoClientSettings)MongoClientSettings.builder().addCommandListener((CommandListener)new MongoMetricsCommandListener(meterRegistry)).applyToConnectionPoolSettings(builder -> builder.addConnectionPoolListener((ConnectionPoolListener)new MongoMetricsConnectionPoolListener(meterRegistry)).build()).applyConnectionString(connectionString).uuidRepresentation(UuidRepresentation.JAVA_LEGACY).build());
        CodecRegistry pojoCodecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
        MongoDatabase db = mongo.getDatabase(this.database).withCodecRegistry(pojoCodecRegistry);
        GridFSBucket gridFsBucket = GridFSBuckets.create((MongoDatabase)db);
        MongoCollection filesCollection = db.getCollection("fs.files");
        filesCollection.createIndex(Indexes.ascending((String[])new String[]{"metadata.projectId", "metadata.fileType"}));
        return gridFsBucket;
    }

    public MiaGridFsConfiguration(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

