/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.mia.controllers.api.MiaHistoryChangesControllerApi;
import org.qubership.atp.mia.controllers.api.dto.CompareEntityResponseDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemResponseDto;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.service.history.RestoreHistoryService;
import org.qubership.atp.mia.service.history.RetrieveHistoryService;
import org.qubership.atp.mia.service.history.impl.HistoryServiceFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoryChangeController
implements MiaHistoryChangesControllerApi {
    private final HistoryServiceFactory historyServiceFactory;

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#itemType, #projectId, 'READ')")
    public ResponseEntity<HistoryItemResponseDto> getAllHistory(UUID projectId, String itemType, UUID id, @Valid Integer offset, @Valid Integer limit) {
        Optional<RetrieveHistoryService<? extends DateAuditorEntity>> historyServiceOptional = this.historyServiceFactory.getRetrieveHistoryService(itemType);
        if (historyServiceOptional.isPresent()) {
            RetrieveHistoryService<? extends DateAuditorEntity> retrieveHistoryService = historyServiceOptional.get();
            HistoryItemResponseDto response = retrieveHistoryService.getAllHistory(id, offset, limit);
            return ResponseEntity.ok((Object)response);
        }
        throw new RuntimeException(itemType);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#itemType, #projectId, 'READ')")
    public ResponseEntity<List<CompareEntityResponseDto>> getEntitiesByVersion(UUID projectId, String itemType, UUID uuid, List<String> versions) {
        Optional<RetrieveHistoryService<? extends DateAuditorEntity>> historyServiceOptional = this.historyServiceFactory.getRetrieveHistoryService(itemType);
        if (historyServiceOptional.isPresent()) {
            return ResponseEntity.ok(historyServiceOptional.get().getEntitiesByVersions(uuid, versions));
        }
        throw new RuntimeException(itemType);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#itemType,#projectId,'UPDATE')")
    public ResponseEntity<Void> restoreToRevision(UUID projectId, String itemType, UUID id, Integer revisionId) {
        Optional<RestoreHistoryService> historyServiceOptional = this.historyServiceFactory.getRestoreHistoryService(itemType);
        if (historyServiceOptional.isPresent()) {
            historyServiceOptional.get().restoreToRevision(id, revisionId.intValue());
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        throw new RuntimeException(itemType);
    }

    public HistoryChangeController(HistoryServiceFactory historyServiceFactory) {
        this.historyServiceFactory = historyServiceFactory;
    }
}

