/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.mia.clients.api.environments.dto.projects.SystemEnvironmentsViewDto;
import org.qubership.atp.mia.model.environment.AbstractConfiguratorModel;
import org.qubership.atp.mia.model.environment.Environment;
import org.qubership.atp.mia.model.environment.Project;
import org.qubership.atp.mia.service.configuration.EnvironmentsService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest"})
@RestController
public class MiaEnvironmentController {
    private final EnvironmentsService service;

    public MiaEnvironmentController(EnvironmentsService service) {
        this.service = service;
    }

    @GetMapping(value={"/project"})
    @AuditAction(auditAction="Get Project details for projectId - {{#projectId}}")
    public Project getProject(@RequestParam(value="projectId") UUID projectId) {
        return this.service.getProject(projectId);
    }

    @GetMapping(value={"/environments"})
    @AuditAction(auditAction="Get Environments for projectId - {{#projectId}}")
    public List<AbstractConfiguratorModel> getEnvironments(@RequestParam(value="projectId") UUID projectId) {
        return this.service.getEnvironmentsByProject(projectId);
    }

    @GetMapping(value={"/environments/full"})
    @AuditAction(auditAction="Get Full Environment details for projectId - {{#projectId}} and environmentId - {{#environmentId}}")
    public Environment getEnvironmentsFull(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="environmentId") UUID environmentId) {
        return this.service.getEnvironmentsFull(environmentId, projectId);
    }

    @GetMapping(value={"/environments/systems"})
    @AuditAction(auditAction="Get all systems for projectId - {{#projectId}}")
    public List<SystemEnvironmentsViewDto> getSystemsForProject(@RequestParam(value="projectId") UUID projectId) {
        return this.service.getSystemsForProject(projectId);
    }

    @GetMapping(value={"/projects"})
    @AuditAction(auditAction="Get all projects")
    public List<AbstractConfiguratorModel> getProjects() {
        return this.service.getProjects();
    }
}

