/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.service.execution.CompoundService;
import org.qubership.atp.mia.service.execution.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest"})
@RestController
public class MiaExecutionController {
    private static final Logger log = LoggerFactory.getLogger(MiaExecutionController.class);
    private final ProcessService processService;
    private final CompoundService compoundService;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.mia.model.UserManagementEntities).COMPOUND.getName(),#projectId, 'EXECUTE')")
    @PostMapping(value={"/flow/execute/compound"})
    @AuditAction(auditAction="Execute Compound initiated for compound \"{{#request.compound.name}}\" in Project - {{#projectId}}")
    public ResponseEntity<LinkedList<ExecutionResponse>> executeCompound(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="env") String env, @RequestBody ExecutionRequest request) {
        return ResponseEntity.ok(this.compoundService.executeCompound(request, null));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.mia.model.UserManagementEntities).PROCESS.getName(),#projectId, \"EXECUTE\")")
    @PostMapping(value={"/flow/execute/current/statement"})
    @AuditAction(auditAction="Execute Current Statement from Process - \"{{#executableName}}\" in Project - {{#projectId}}")
    public ResponseEntity<List<SqlResponse>> executeCurrentStatement(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="env") String env, @RequestBody ExecutionRequest request) {
        return ResponseEntity.ok(this.processService.executeCurrentStatement(request.getProcess()));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.mia.model.UserManagementEntities).PROCESS.getName(),#projectId, 'EXECUTE')")
    @PostMapping(value={"/flow/execute/process"})
    @AuditAction(auditAction="Execute Process initiated for Process - \"{{#request.process}}\" in Project - {{#projectId}}")
    public ResponseEntity<ExecutionResponse> executeProcess(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="env") String env, @RequestBody ExecutionRequest request) {
        return ResponseEntity.ok((Object)this.processService.executeProcess(request, null));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.mia.model.UserManagementEntities).PROCESS.getName(),#projectId, \"EXECUTE\")")
    @PostMapping(value={"/flow/calculateNextBillDate"})
    @AuditAction(auditAction="getNextBillDate called in project - {{#projectId}} for environment - {{#env}}")
    public String getNextBillDate(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="env") String env, @RequestBody ExecutionRequest request) {
        return this.processService.getNextBillDate();
    }

    public MiaExecutionController(ProcessService processService, CompoundService compoundService) {
        this.processService = processService;
        this.compoundService = compoundService;
    }
}

