/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import com.google.gson.Gson;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.mia.controllers.api.MiaFileControllerApi;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.execution.TestDataService;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class MiaFileController
implements MiaFileControllerApi {
    private final MiaFileService miaFileService;
    private final TestDataService testDataService;
    private final ServletContext servletContext;
    private final MiaContext miaContext;

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Download a logfile in project - {{#projectId}}")
    public ResponseEntity<Resource> downloadFile(UUID projectId, UUID sessionId, String logFile) {
        return this.miaFileService.downloadFile(projectId, ProjectFileType.MIA_FILE_TYPE_LOG, sessionId, logFile, this.servletContext);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="DownloadFileFromUploads called for project {{#projectId}}")
    public ResponseEntity<Resource> downloadFileFromUploads(UUID projectId, UUID sessionId, String logFile) {
        return this.miaFileService.downloadFile(projectId, ProjectFileType.MIA_FILE_TYPE_UPLOAD, sessionId, logFile, this.servletContext);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Download process execution output as Zip for process - \"{{#processName}}\" in Project - {{#projectId}} ")
    public ResponseEntity<Resource> downloadOutputAsZip(UUID projectId, UUID sessionId, String processName, List<String> filePaths) {
        if (filePaths != null) {
            filePaths.forEach(this.miaFileService::getFile);
        }
        String filename = this.miaContext.zipCommandOutputs(processName, filePaths).getName();
        return this.downloadFile(projectId, this.miaContext.getFlowData().getSessionId(), filename);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Upload a file. Project : {{#projectId}}")
    public ResponseEntity<String> handleFileUpload(UUID projectId, UUID sessionId, Boolean needDos2Unix, MultipartFile file) {
        return ResponseEntity.ok((Object)new Gson().toJson((Object)this.miaFileService.uploadFileOnBe(file, needDos2Unix)));
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Upload Test data matrix, in Project : {{#projectId}}")
    public ResponseEntity<String> handleTestDataFileUpload(UUID projectId, UUID sessionId, MultipartFile file) {
        return ResponseEntity.ok((Object)new Gson().toJson((Object)this.testDataService.uploadTestDataFileAndValidate(file)));
    }

    public MiaFileController(MiaFileService miaFileService, TestDataService testDataService, ServletContext servletContext, MiaContext miaContext) {
        this.miaFileService = miaFileService;
        this.testDataService = testDataService;
        this.servletContext = servletContext;
        this.miaContext = miaContext;
    }
}

