/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.repo.impl.ProofOfTestingRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rest"})
@RestController
public class MiaProofOfTestingController {
    private final MiaContext miaContext;
    private final ProofOfTestingRepository proofOfTestingRepository;

    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @PostMapping(value={"/pot/session/start"})
    @AuditAction(auditAction="Start MIA POT Session in project {{#projectId}}")
    public UUID startSession(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="sessionId", required=false) UUID oldSessionId) {
        return UUID.randomUUID();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @PostMapping(value={"/pot/save"})
    @AuditAction(auditAction="Save MIA POT for sessionId {{#sessionId}} in project {{#projectId}}")
    public List<Link> saveProofOfTesting(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="sessionId") UUID sessionId, @RequestBody ExecutionRequest request) {
        return this.proofOfTestingRepository.downloadProofOfTesting();
    }

    public MiaProofOfTestingController(MiaContext miaContext, ProofOfTestingRepository proofOfTestingRepository) {
        this.miaContext = miaContext;
        this.proofOfTestingRepository = proofOfTestingRepository;
    }
}

