/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="mia-cache-controller", description="MIA Cache Controller")
public interface MiaCacheControllerApi {
    @Operation(operationId="resetConfigurationCache", summary="Reset mia configuration cache", tags={"mia-cache-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/resetConfigurationCache"}, produces={"application/json"})
    public ResponseEntity<Boolean> resetConfigurationCache(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1);

    @Operation(operationId="resetDbCache", summary="Reset DB Cache for Project", tags={"mia-cache-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/flow/resetCache"}, produces={"application/json"})
    public ResponseEntity<Boolean> resetDbCache(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="env", description="environmentName", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="env", required=true) String var2);

    @Operation(operationId="resetEnvironmentCaches", summary="Reset mia environment Caches", tags={"mia-cache-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/resetEnvCaches"}, produces={"application/json"})
    public ResponseEntity<Boolean> resetEnvironmentCaches(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1);

    @Operation(operationId="resetPoolCache", summary="Reset mia poolcache", tags={"mia-cache-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/resetPoolCache"}, produces={"application/json"})
    public ResponseEntity<Boolean> resetPoolCache(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1);
}

