/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.CompoundDto;
import org.qubership.atp.mia.controllers.api.dto.CompoundShortDto;
import org.qubership.atp.mia.controllers.api.dto.FlowConfigDto;
import org.qubership.atp.mia.controllers.api.dto.MoveDirectoryRequestDto;
import org.qubership.atp.mia.controllers.api.dto.MoveProjectFileRequestDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessShortDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectConfigurationDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectDirectoriesDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectDirectoryDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectFileDto;
import org.qubership.atp.mia.controllers.api.dto.SectionDto;
import org.qubership.atp.mia.controllers.api.dto.SectionsDto;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Validated
@Tag(name="mia-configuration-controller", description="MIA Configuration Controller")
public interface MiaConfigurationControllerApi {
    @Operation(operationId="addCompound", description="Add mia compound", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompoundDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/configuration/{projectId}/compound"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<CompoundDto> addCompound(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="CompoundDto", description="request", required=true) @Valid @RequestBody CompoundDto var2);

    @Operation(operationId="addDirectory", description="Add mia directory", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/configuration/{projectId}/directory"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<Void> addDirectory(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="ProjectDirectoryDto", description="request", required=true) @Valid @RequestBody ProjectDirectoryDto var2);

    @Operation(operationId="addProcess", description="Add mia process", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProcessDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/configuration/{projectId}/process"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<ProcessDto> addProcess(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="ProcessDto", description="request", required=true) @Valid @RequestBody ProcessDto var2);

    @Operation(operationId="addProjectFile", description="Add mia project file", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/configuration/{projectId}/projectFile"}, consumes={"multipart/form-data"})
    public ResponseEntity<Void> addProjectFile(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="projectFile", description="", required=true) @Valid @RequestPart(value="projectFile", required=true) ProjectFileDto var2, @Parameter(name="file", description="", required=true) @RequestPart(value="file", required=true) MultipartFile var3);

    @Operation(operationId="addSection", description="Add mia section", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SectionsDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/configuration/{projectId}/section"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<List<SectionsDto>> addSection(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="SectionDto", description="request", required=true) @Valid @RequestBody SectionDto var2);

    @Operation(operationId="deleteCompound", description="Delete mia compound", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CompoundShortDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/configuration/{projectId}/compound/{compoundId}"}, produces={"application/json"})
    public ResponseEntity<List<CompoundShortDto>> deleteCompound(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="compoundId", description="Compound ID", required=true, in=ParameterIn.PATH) @PathVariable(value="compoundId") UUID var2);

    @Operation(operationId="deleteConfiguration", description="Delete mia configuration", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/configuration/{projectId}"})
    public ResponseEntity<Void> deleteConfiguration(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @NotNull @Parameter(name="withPOT", description="Remove with POT", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="withPOT", required=true) Boolean var2);

    @Operation(operationId="deleteDirectory", description="Delete mia directory", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/configuration/{projectId}/directory/{directoryId}"})
    public ResponseEntity<Void> deleteDirectory(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="directoryId", description="Directory ID", required=true, in=ParameterIn.PATH) @PathVariable(value="directoryId") UUID var2);

    @Operation(operationId="deleteProcess", description="Delete mia process", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ProcessShortDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/configuration/{projectId}/process/{processId}"}, produces={"application/json"})
    public ResponseEntity<List<ProcessShortDto>> deleteProcess(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="processId", description="Process ID", required=true, in=ParameterIn.PATH) @PathVariable(value="processId") UUID var2);

    @Operation(operationId="deleteProjectFile", description="Delete mia section", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/configuration/{projectId}/projectFile/{fileId}"})
    public ResponseEntity<Void> deleteProjectFile(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="fileId", description="Project file ID", required=true, in=ParameterIn.PATH) @PathVariable(value="fileId") UUID var2);

    @Operation(operationId="deleteSection", description="Delete mia section", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SectionsDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/configuration/{projectId}/section/{sectionId}"}, produces={"application/json"})
    public ResponseEntity<List<SectionsDto>> deleteSection(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="sectionId", description="Section ID", required=true, in=ParameterIn.PATH) @PathVariable(value="sectionId") UUID var2);

    @Operation(operationId="downloadZipConfig", description="Download config as ZIP file", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/downloadZipConfig"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadZipConfig(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getCompound", description="Get mia compound", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompoundDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/compound/{compoundId}"}, produces={"application/json"})
    public ResponseEntity<CompoundDto> getCompound(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="compoundId", description="Compound ID", required=true, in=ParameterIn.PATH) @PathVariable(value="compoundId") UUID var2);

    @Operation(operationId="getCompounds", description="Get mia all compounds for the project", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CompoundShortDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/compound"}, produces={"application/json"})
    public ResponseEntity<List<CompoundShortDto>> getCompounds(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Deprecated
    @Operation(operationId="getConfig", description="IMPORTANT. IT IS OLD CONFIG!!! USE /configuration/{projectId}, /configuration/{projectId}/section,  /configuration/{projectId}/compound, /configuration/{projectId}/process instead. ", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=FlowConfigDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/config"}, produces={"application/json"})
    public ResponseEntity<FlowConfigDto> getConfig(@NotNull @Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="needReload", description="needReload", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="needReload", required=true) Boolean var2);

    @Operation(operationId="getConfiguration", description="Get mia configuration", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectConfigurationDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}"}, produces={"application/json"})
    public ResponseEntity<ProjectConfigurationDto> getConfiguration(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getConfigurationWithHardReload", description="Hard reload mia configuration from external resourse and return it", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectConfigurationDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/hardReload"}, produces={"application/json"})
    public ResponseEntity<ProjectConfigurationDto> getConfigurationWithHardReload(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getDirectories", description="Get mia directories hierarchy", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDirectoriesDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/directory"}, produces={"application/json"})
    public ResponseEntity<ProjectDirectoriesDto> getDirectories(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getProcess", description="Get mia process", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProcessDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/process/{processId}"}, produces={"application/json"})
    public ResponseEntity<ProcessDto> getProcess(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="processId", description="Process ID", required=true, in=ParameterIn.PATH) @PathVariable(value="processId") UUID var2);

    @Operation(operationId="getProcesses", description="Get mia all processes for the project", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ProcessShortDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/process"}, produces={"application/json"})
    public ResponseEntity<List<ProcessShortDto>> getProcesses(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getProjectFile", description="Get mia project file", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/projectFile/{fileId}"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> getProjectFile(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="fileId", description="Project file ID", required=true, in=ParameterIn.PATH) @PathVariable(value="fileId") UUID var2);

    @Operation(operationId="getSections", description="Get mia sections hierarchy", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SectionsDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/section"}, produces={"application/json"})
    public ResponseEntity<List<SectionsDto>> getSections(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getUuidDirectories", description="Get mia list of uuids for all directories", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UUID.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/directories"}, produces={"application/json"})
    public ResponseEntity<List<UUID>> getUuidDirectories(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getUuidFiles", description="Get mia list of uuids for all files", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UUID.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/configuration/{projectId}/projectFiles"}, produces={"application/json"})
    public ResponseEntity<List<UUID>> getUuidFiles(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="moveDirectory", description="Move mia project directory", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/configuration/{projectId}/directory/{directoryId}"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<Void> moveDirectory(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="directoryId", description="Directory ID", required=true, in=ParameterIn.PATH) @PathVariable(value="directoryId") UUID var2, @Parameter(name="MoveDirectoryRequestDto", description="", required=true) @Valid @RequestBody MoveDirectoryRequestDto var3);

    @Operation(operationId="moveProjectFile", description="Move mia project file", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/configuration/{projectId}/projectFile/{fileId}"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<Void> moveProjectFile(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="fileId", description="Project file ID", required=true, in=ParameterIn.PATH) @PathVariable(value="fileId") UUID var2, @Parameter(name="MoveProjectFileRequestDto", description="", required=true) @Valid @RequestBody MoveProjectFileRequestDto var3);

    @Operation(operationId="updateCompound", description="Update mia compound", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompoundDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/configuration/{projectId}/compound"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<CompoundDto> updateCompound(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="CompoundDto", description="request", required=true) @Valid @RequestBody CompoundDto var2);

    @Operation(operationId="updateConfiguration", description="Update mia configuration", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectConfigurationDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/configuration/{projectId}"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<ProjectConfigurationDto> updateConfiguration(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="ProjectConfigurationDto", description="request", required=true) @Valid @RequestBody ProjectConfigurationDto var2);

    @Operation(operationId="updateDirectory", description="Update mia directory", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/configuration/{projectId}/directory"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<Void> updateDirectory(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="ProjectDirectoryDto", description="request", required=true) @Valid @RequestBody ProjectDirectoryDto var2);

    @Operation(operationId="updateProcess", description="Update mia process", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProcessDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/configuration/{projectId}/process"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<ProcessDto> updateProcess(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="ProcessDto", description="request", required=true) @Valid @RequestBody ProcessDto var2);

    @Operation(operationId="updateProjectFile", description="Update mia project file", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/configuration/{projectId}/projectFile"}, consumes={"multipart/form-data"})
    public ResponseEntity<Void> updateProjectFile(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="projectFile", description="", required=true) @Valid @RequestPart(value="projectFile", required=true) ProjectFileDto var2, @Parameter(name="file", description="file") @RequestPart(value="file", required=false) MultipartFile var3);

    @Operation(operationId="updateSection", description="Update mia section", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SectionsDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/configuration/{projectId}/section"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<List<SectionsDto>> updateSection(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="SectionDto", description="request", required=true) @Valid @RequestBody SectionDto var2);

    @Operation(operationId="uploadZipConfig", description="Upload config as ZIP file", tags={"mia-configuration-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/configuration/{projectId}/uploadZipConfig"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public ResponseEntity<Boolean> uploadZipConfig(@Parameter(name="projectId", description="Project ID", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="file", description="file", required=true) @RequestPart(value="file", required=true) MultipartFile var2);
}

