/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.ExecutionRequestDto;
import org.qubership.atp.mia.controllers.api.dto.ExecutionResponseDto;
import org.qubership.atp.mia.controllers.api.dto.FlowDataDto;
import org.qubership.atp.mia.controllers.api.dto.SqlResponseDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="mia-execution-controller", description="MIA Execution Controller")
public interface MiaExecutionControllerApi {
    @Operation(operationId="executeCompound", summary="Execute Compound", tags={"mia-execution-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ExecutionResponseDto.class)))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/flow/execute/compound"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<List<ExecutionResponseDto>> executeCompound(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="env", description="environmentName", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="env", required=true) String var2, @Parameter(name="request", description="request", required=true) @Valid @RequestBody ExecutionRequestDto var3);

    @Operation(operationId="executeCurrentStatement", summary="Execute CurrentStatement", tags={"mia-execution-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SqlResponseDto.class)))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/flow/execute/current/statement"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<SqlResponseDto>> executeCurrentStatement(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="env", description="environment", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="env", required=true) String var2, @NotNull @Parameter(name="executableName", description="executableName", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="executableName", required=true) String var3, @NotNull @Parameter(name="sessionId", description="Session ID", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=true) UUID var4, @Parameter(name="flowData", description="flowData", required=true) @Valid @RequestBody FlowDataDto var5);

    @Operation(operationId="executeProcess", summary="Execute Process", tags={"mia-execution-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ExecutionResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/flow/execute/process"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<ExecutionResponseDto> executeProcess(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="env", description="environmentName", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="env", required=true) String var2, @Parameter(name="request", description="request", required=true) @Valid @RequestBody ExecutionRequestDto var3);

    @Operation(operationId="getNextBillDate", summary="Get Next Bill Date for Given Account Id", tags={"mia-execution-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/flow/calculateNextBillDate"}, produces={"application/json"}, consumes={"application/json; charset=UTF-8"})
    public ResponseEntity<String> getNextBillDate(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="env", description="environmentName", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="env", required=true) String var2, @Parameter(name="ExecutionRequestDto", description="request", required=true) @Valid @RequestBody ExecutionRequestDto var3);
}

