/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Validated
@Tag(name="mia-file-controller", description="MIA File Controller")
public interface MiaFileControllerApi {
    @Operation(operationId="downloadFile", description="Download file of execution", tags={"mia-file-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/downloadFile/{projectId}/MIA_FILE_TYPE_LOG/{sessionId}/{logFile}"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadFile(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="sessionId", description="sessionId", required=true, in=ParameterIn.PATH) @PathVariable(value="sessionId") UUID var2, @Parameter(name="logFile", description="logFile", required=true, in=ParameterIn.PATH) @PathVariable(value="logFile") String var3);

    @Operation(operationId="downloadFileFromUploads", description="Download file from uploads", tags={"mia-file-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/downloadFile/{projectId}/MIA_FILE_TYPE_UPLOAD/{sessionId}/{logFile}"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadFileFromUploads(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="sessionId", description="sessionId", required=true, in=ParameterIn.PATH) @PathVariable(value="sessionId") UUID var2, @Parameter(name="logFile", description="logFile", required=true, in=ParameterIn.PATH) @PathVariable(value="logFile") String var3);

    @Operation(operationId="downloadOutputAsZip", description="downloadOutputAsZip", tags={"mia-file-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Resource.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/downloadOutputAsZip"}, produces={"application/octet-stream"}, consumes={"application/json"})
    public ResponseEntity<Resource> downloadOutputAsZip(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="sessionId", description="sessionId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=true) UUID var2, @NotNull @Parameter(name="processName", description="processName", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="processName", required=true) String var3, @Parameter(name="request_body", description="filePaths", required=true) @Valid @RequestBody List<String> var4);

    @Operation(operationId="handleFileUpload", description="Upload file for project.", tags={"mia-file-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/uploadFile"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public ResponseEntity<String> handleFileUpload(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="sessionId", description="sessionId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=true) UUID var2, @Parameter(name="needDos2Unix", description="needDos2Unix", in=ParameterIn.QUERY) @Valid @RequestParam(value="needDos2Unix", required=false) Boolean var3, @Parameter(name="file", description="file") @RequestPart(value="file", required=false) MultipartFile var4);

    @Operation(operationId="handleTestDataFileUpload", description="handleTestDataFileUpload", tags={"mia-file-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/uploadTestDataFile"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public ResponseEntity<String> handleTestDataFileUpload(@NotNull @Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="sessionId", description="sessionId", in=ParameterIn.QUERY) @Valid @RequestParam(value="sessionId", required=false) UUID var2, @Parameter(name="file", description="file") @RequestPart(value="file", required=false) MultipartFile var3);
}

