/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.ProcessDto;

@JsonTypeName(value="Compound")
public class CompoundDto {
    private UUID id;
    private String name;
    private String referToInput;
    @Valid
    private @Valid List<@Valid ProcessDto> processes;
    @Valid
    private List<UUID> inSections;

    @Deprecated
    public CompoundDto() {
    }

    public CompoundDto(String name) {
        this.name = name;
    }

    public CompoundDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public CompoundDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompoundDto referToInput(String referToInput) {
        this.referToInput = referToInput;
        return this;
    }

    @Schema(name="referToInput", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="referToInput")
    public String getReferToInput() {
        return this.referToInput;
    }

    public void setReferToInput(String referToInput) {
        this.referToInput = referToInput;
    }

    public CompoundDto processes(List<@Valid ProcessDto> processes) {
        this.processes = processes;
        return this;
    }

    public CompoundDto addProcessesItem(ProcessDto processesItem) {
        if (this.processes == null) {
            this.processes = new ArrayList<ProcessDto>();
        }
        this.processes.add(processesItem);
        return this;
    }

    @Valid
    @Schema(name="processes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processes")
    public @Valid List<@Valid ProcessDto> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<@Valid ProcessDto> processes) {
        this.processes = processes;
    }

    public CompoundDto inSections(List<UUID> inSections) {
        this.inSections = inSections;
        return this;
    }

    public CompoundDto addInSectionsItem(UUID inSectionsItem) {
        if (this.inSections == null) {
            this.inSections = new ArrayList<UUID>();
        }
        this.inSections.add(inSectionsItem);
        return this;
    }

    @Valid
    @Schema(name="inSections", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inSections")
    public List<UUID> getInSections() {
        return this.inSections;
    }

    public void setInSections(List<UUID> inSections) {
        this.inSections = inSections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundDto compound = (CompoundDto)o;
        return Objects.equals(this.id, compound.id) && Objects.equals(this.name, compound.name) && Objects.equals(this.referToInput, compound.referToInput) && Objects.equals(this.processes, compound.processes) && Objects.equals(this.inSections, compound.inSections);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.referToInput, this.processes, this.inSections);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompoundDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referToInput: ").append(this.toIndentedString(this.referToInput)).append("\n");
        sb.append("    processes: ").append(this.toIndentedString(this.processes)).append("\n");
        sb.append("    inSections: ").append(this.toIndentedString(this.inSections)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

