/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;

@JsonTypeName(value="HistoryItem")
public class HistoryItemDto {
    private HistoryItemTypeDto type;
    private Integer version;
    private String modifiedWhen;
    private String modifiedBy;
    @Valid
    private List<String> added;
    @Valid
    private List<String> deleted;
    @Valid
    private List<String> changed;

    public HistoryItemDto type(HistoryItemTypeDto type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public HistoryItemTypeDto getType() {
        return this.type;
    }

    public void setType(HistoryItemTypeDto type) {
        this.type = type;
    }

    public HistoryItemDto version(Integer version) {
        this.version = version;
        return this;
    }

    @Min(value=1L)
    @Schema(name="version", description="commit number of current changes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public @Min(value=1L) Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public HistoryItemDto modifiedWhen(String modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
        return this;
    }

    @Schema(name="modifiedWhen", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="modifiedWhen")
    public String getModifiedWhen() {
        return this.modifiedWhen;
    }

    public void setModifiedWhen(String modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public HistoryItemDto modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @Schema(name="modifiedBy", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public HistoryItemDto added(List<String> added) {
        this.added = added;
        return this;
    }

    public HistoryItemDto addAddedItem(String addedItem) {
        if (this.added == null) {
            this.added = new ArrayList<String>();
        }
        this.added.add(addedItem);
        return this;
    }

    @Schema(name="added", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="added")
    public List<String> getAdded() {
        return this.added;
    }

    public void setAdded(List<String> added) {
        this.added = added;
    }

    public HistoryItemDto deleted(List<String> deleted) {
        this.deleted = deleted;
        return this;
    }

    public HistoryItemDto addDeletedItem(String deletedItem) {
        if (this.deleted == null) {
            this.deleted = new ArrayList<String>();
        }
        this.deleted.add(deletedItem);
        return this;
    }

    @Schema(name="deleted", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="deleted")
    public List<String> getDeleted() {
        return this.deleted;
    }

    public void setDeleted(List<String> deleted) {
        this.deleted = deleted;
    }

    public HistoryItemDto changed(List<String> changed) {
        this.changed = changed;
        return this;
    }

    public HistoryItemDto addChangedItem(String changedItem) {
        if (this.changed == null) {
            this.changed = new ArrayList<String>();
        }
        this.changed.add(changedItem);
        return this;
    }

    @Schema(name="changed", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="changed")
    public List<String> getChanged() {
        return this.changed;
    }

    public void setChanged(List<String> changed) {
        this.changed = changed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryItemDto historyItem = (HistoryItemDto)o;
        return Objects.equals((Object)this.type, (Object)historyItem.type) && Objects.equals(this.version, historyItem.version) && Objects.equals(this.modifiedWhen, historyItem.modifiedWhen) && Objects.equals(this.modifiedBy, historyItem.modifiedBy) && Objects.equals(this.added, historyItem.added) && Objects.equals(this.deleted, historyItem.deleted) && Objects.equals(this.changed, historyItem.changed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.version, this.modifiedWhen, this.modifiedBy, this.added, this.deleted, this.changed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryItemDto {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    modifiedWhen: ").append(this.toIndentedString(this.modifiedWhen)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    added: ").append(this.toIndentedString(this.added)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    changed: ").append(this.toIndentedString(this.changed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

