/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.CompoundShortDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessShortDto;

@JsonTypeName(value="Sections")
public class SectionsDto {
    private UUID id;
    private String name;
    private UUID parentSection;
    private BigDecimal place;
    @Valid
    private @Valid List<@Valid SectionsDto> sections;
    @Valid
    private @Valid List<@Valid CompoundShortDto> compounds;
    @Valid
    private @Valid List<@Valid ProcessShortDto> processes;

    @Deprecated
    public SectionsDto() {
    }

    public SectionsDto(String name) {
        this.name = name;
    }

    public SectionsDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SectionsDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SectionsDto parentSection(UUID parentSection) {
        this.parentSection = parentSection;
        return this;
    }

    @Valid
    @Schema(name="parentSection", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="parentSection")
    public UUID getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(UUID parentSection) {
        this.parentSection = parentSection;
    }

    public SectionsDto place(BigDecimal place) {
        this.place = place;
        return this;
    }

    @Valid
    @Schema(name="place", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="place")
    public BigDecimal getPlace() {
        return this.place;
    }

    public void setPlace(BigDecimal place) {
        this.place = place;
    }

    public SectionsDto sections(List<@Valid SectionsDto> sections) {
        this.sections = sections;
        return this;
    }

    public SectionsDto addSectionsItem(SectionsDto sectionsItem) {
        if (this.sections == null) {
            this.sections = new ArrayList<SectionsDto>();
        }
        this.sections.add(sectionsItem);
        return this;
    }

    @Valid
    @Schema(name="sections", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="sections")
    public @Valid List<@Valid SectionsDto> getSections() {
        return this.sections;
    }

    public void setSections(List<@Valid SectionsDto> sections) {
        this.sections = sections;
    }

    public SectionsDto compounds(List<@Valid CompoundShortDto> compounds) {
        this.compounds = compounds;
        return this;
    }

    public SectionsDto addCompoundsItem(CompoundShortDto compoundsItem) {
        if (this.compounds == null) {
            this.compounds = new ArrayList<CompoundShortDto>();
        }
        this.compounds.add(compoundsItem);
        return this;
    }

    @Valid
    @Schema(name="compounds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="compounds")
    public @Valid List<@Valid CompoundShortDto> getCompounds() {
        return this.compounds;
    }

    public void setCompounds(List<@Valid CompoundShortDto> compounds) {
        this.compounds = compounds;
    }

    public SectionsDto processes(List<@Valid ProcessShortDto> processes) {
        this.processes = processes;
        return this;
    }

    public SectionsDto addProcessesItem(ProcessShortDto processesItem) {
        if (this.processes == null) {
            this.processes = new ArrayList<ProcessShortDto>();
        }
        this.processes.add(processesItem);
        return this;
    }

    @Valid
    @Schema(name="processes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processes")
    public @Valid List<@Valid ProcessShortDto> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<@Valid ProcessShortDto> processes) {
        this.processes = processes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SectionsDto sections = (SectionsDto)o;
        return Objects.equals(this.id, sections.id) && Objects.equals(this.name, sections.name) && Objects.equals(this.parentSection, sections.parentSection) && Objects.equals(this.place, sections.place) && Objects.equals(this.sections, sections.sections) && Objects.equals(this.compounds, sections.compounds) && Objects.equals(this.processes, sections.processes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.parentSection, this.place, this.sections, this.compounds, this.processes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SectionsDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentSection: ").append(this.toIndentedString(this.parentSection)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    sections: ").append(this.toIndentedString(this.sections)).append("\n");
        sb.append("    compounds: ").append(this.toIndentedString(this.compounds)).append("\n");
        sb.append("    processes: ").append(this.toIndentedString(this.processes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

