/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.ei.MiaImportEntityException;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImportLoader<E extends ExportImportEntities, T extends Serializable, F extends ExportImportIdentifier> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoader.class);
    public static final String EI_CONFLICT = "_ImportConflict_";
    protected final ObjectLoaderFromDiskService objectLoaderFromDiskService;

    public abstract Class<F> getClazz();

    public abstract E getEntityType();

    public abstract void importEntity(ProjectConfiguration var1, ExportImportData var2, Path var3);

    public abstract T toEntity(ProjectConfiguration var1, F var2);

    public abstract List<UUID> validate(ProjectConfiguration var1, ExportImportData var2, Path var3) throws MiaException;

    protected List<F> loadConfiguration(ExportImportData importData, Path path) {
        log.info("Extract {} during import", this.getEntityType());
        ArrayList extractedFolderEntities = new ArrayList();
        Path entityPath = Paths.get(path.toString(), new String[0]);
        Map entityFiles = this.objectLoaderFromDiskService.getListOfObjects(entityPath, this.getClazz());
        Map replacementMap = importData.getReplacementMap();
        log.debug("Extracted {} list with paths: {}", this.getEntityType(), (Object)entityFiles);
        boolean isReplacement = importData.isInterProjectImport() || importData.isCreateNewProject();
        entityFiles.forEach((id, filePath) -> {
            log.debug("Extract {} configuration with ID {}", this.getEntityType(), id);
            F entityConfiguration = this.load((Path)filePath, replacementMap, isReplacement);
            log.debug("Loaded {} configuration: {}", this.getEntityType(), entityConfiguration);
            if (entityConfiguration == null) {
                throw new MiaImportEntityException((ExportImportEntities)((Object)((Object)this.getEntityType())), (Path)filePath);
            }
            ((ExportImportIdentifier)entityConfiguration).setSourceId((UUID)id);
            extractedFolderEntities.add(entityConfiguration);
        });
        log.info("{} are extracted during import: {}", this.getEntityType(), (Object)extractedFolderEntities.size());
        return extractedFolderEntities;
    }

    protected List<UUID> replaceIdsBack(List<UUID> uuids, Map<UUID, UUID> map) {
        ArrayList<UUID> returnList = new ArrayList<UUID>();
        uuids.forEach(uuid -> returnList.add((UUID)((Map.Entry)map.entrySet().stream().filter(entry -> uuid.equals(entry.getValue())).findFirst().orElse(new AbstractMap.SimpleEntry<UUID, UUID>((UUID)uuid, (UUID)uuid))).getKey()));
        return returnList;
    }

    private F load(Path filePath, Map<UUID, UUID> replacementMap, boolean isReplacement) {
        if (isReplacement) {
            log.debug("Load {} by path [{}] with replacementMap: {}", new Object[]{this.getEntityType(), filePath, replacementMap});
            return (F)((ExportImportIdentifier)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(filePath, this.getClazz(), replacementMap, true, false));
        }
        log.debug("Load {} by path [{}] without replacementMap", this.getEntityType(), (Object)filePath);
        return (F)((ExportImportIdentifier)this.objectLoaderFromDiskService.loadFileAsObject(filePath, this.getClazz()));
    }

    public ImportLoader(ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
    }
}

