/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportCompound;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportIdentifier;
import org.qubership.atp.mia.service.configuration.ProcessConfigurationService;
import org.qubership.atp.mia.service.configuration.SectionConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportLoaderCompound
extends ImportLoader<ExportImportEntities, CompoundConfiguration, ExportImportCompound> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderCompound.class);

    public ImportLoaderCompound(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        super(objectLoaderFromDiskService);
    }

    @Override
    public Class<ExportImportCompound> getClazz() {
        return ExportImportCompound.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_COMPOUNDS;
    }

    @Override
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        ArrayList loadedCompounds = new ArrayList();
        List importCompounds = this.loadConfiguration(importData, path);
        importCompounds.forEach(c -> this.loadCompound(projectConfiguration, loadedCompounds, (ExportImportCompound)c, importData));
        loadedCompounds.forEach(c -> this.mergeCompoundOrAdd(projectConfiguration, (CompoundConfiguration)c));
    }

    @Override
    public CompoundConfiguration toEntity(ProjectConfiguration projectConfiguration, ExportImportCompound exportImportCompound) {
        return ((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)new CompoundConfiguration().toBuilder()).id(exportImportCompound.getId())).name(exportImportCompound.getName())).sourceId(exportImportCompound.getSourceId())).referToInput(exportImportCompound.getReferToInput())).processes(new ArrayList<ProcessConfiguration>())).inSections(new ArrayList<SectionConfiguration>())).build();
    }

    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        List loadedCompounds = this.loadConfiguration(importData, path);
        loadedCompounds.forEach(c -> this.loadCompound(projectConfiguration, (List<CompoundConfiguration>)new ArrayList<CompoundConfiguration>(), (ExportImportCompound)c, importData));
        return loadedCompounds.stream().map(ExportImportIdentifier::getId).collect(Collectors.toList());
    }

    private void loadCompound(ProjectConfiguration projectConfiguration, List<CompoundConfiguration> loadedCompounds, ExportImportCompound importCompound, ExportImportData importData) {
        if (loadedCompounds.stream().noneMatch(s -> importCompound.getId().equals(s.getId()))) {
            CompoundConfiguration compound = this.toEntity(projectConfiguration, importCompound);
            List<SectionConfiguration> inSections = SectionConfigurationService.filterSectionsByIdOrSourceId(projectConfiguration.getSections(), importData.isInterProjectImport() || importData.isCreateNewProject() ? this.replaceIdsBack(importCompound.getInSections(), importData.getReplacementMap()) : importCompound.getInSections());
            compound.setProcesses(ProcessConfigurationService.filterProcessesByIdOrSourceId(projectConfiguration.getProcesses(), importData.isInterProjectImport() || importData.isCreateNewProject() ? this.replaceIdsBack(importCompound.getProcesses(), importData.getReplacementMap()) : importCompound.getProcesses()));
            compound.setInSections(inSections);
            loadedCompounds.add(compound);
        }
    }

    private void mergeCompoundOrAdd(ProjectConfiguration projectConfiguration, CompoundConfiguration process) {
        if (process.getSourceId() != null) {
            this.mergeCompoundOrAdd(projectConfiguration, process, process.getSourceId());
        } else {
            this.mergeCompoundOrAdd(projectConfiguration, process, process.getId());
        }
    }

    private void mergeCompoundOrAdd(ProjectConfiguration projectConfiguration, CompoundConfiguration compound, UUID compoundId) {
        Optional<CompoundConfiguration> realCompoundOptional = projectConfiguration.getCompounds().stream().filter(realC -> compoundId.equals(realC.getId()) || compoundId.equals(realC.getSourceId())).findFirst();
        if (realCompoundOptional.isPresent()) {
            CompoundConfiguration realCompound = realCompoundOptional.get();
            realCompound.setName(compound.getName());
            realCompound.setSourceId(compound.getSourceId());
            realCompound.setReferToInput(compound.getReferToInput());
            HashSet<SectionConfiguration> sections = new HashSet<SectionConfiguration>(realCompound.getInSections());
            compound.getInSections().forEach(s -> {
                s.addCompound(realCompound);
                sections.add((SectionConfiguration)s);
            });
            realCompound.setInSections(new ArrayList<SectionConfiguration>(sections));
            compound.setProcesses(realCompound.getProcesses());
            realCompound.getProcesses().forEach(p -> {
                if (!p.getInCompounds().contains(realCompound)) {
                    p.getInCompounds().add(realCompound);
                }
            });
        } else {
            if (projectConfiguration.getCompounds().stream().anyMatch(c -> compound.getName().equals(c.getName()))) {
                compound.setName(compound.getName() + "_ei_" + UUID.randomUUID());
            }
            compound.setProjectConfiguration(projectConfiguration);
            compound.getInSections().forEach(s -> s.addCompound(compound));
            compound.getProcesses().forEach(p -> p.getInCompounds().add(compound));
            projectConfiguration.getCompounds().add(compound);
        }
    }
}

