/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ExportImportUtils;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.ei.MiaImportParentDirectoryNotFound;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportDirectory;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportFile;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.repo.configuration.FileConfigurationRepository;
import org.qubership.atp.mia.service.AtpUserService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ImportLoaderFile
extends ImportLoader<ExportImportEntities, ProjectFile, ExportImportFile> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderFile.class);
    private final GridFsService gridFsService;
    private final AtpUserService atpUserService;
    private final FileConfigurationRepository fileConfigurationRepository;
    private final ProjectConfigurationService projectConfigurationService;

    public ImportLoaderFile(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService, GridFsService gridFsService, AtpUserService atpUserService, FileConfigurationRepository fileConfigurationRepository, ProjectConfigurationService projectConfigurationService) {
        super(objectLoaderFromDiskService);
        this.gridFsService = gridFsService;
        this.fileConfigurationRepository = fileConfigurationRepository;
        this.atpUserService = atpUserService;
        this.projectConfigurationService = projectConfigurationService;
    }

    @Override
    public Class<ExportImportFile> getClazz() {
        return ExportImportFile.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_FILES;
    }

    @Override
    public ProjectFile toEntity(ProjectConfiguration projectConfiguration, ExportImportFile exportImportFile) {
        return ((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)ProjectFile.builder().id(exportImportFile.getId())).sourceId(exportImportFile.getSourceId())).name(exportImportFile.getName())).lastUpdateWhen(LocalDateTime.now())).lastUpdateBy(this.atpUserService.getAtpUser())).projectConfiguration(projectConfiguration)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        ArrayList<UUID> validationIds = new ArrayList<UUID>();
        Map<UUID, ProjectDirectory> existingIdToDirectory = ExportImportUtils.createMapIdToExistingDirectory(projectConfiguration);
        Map<UUID, UUID> reverseReplacementMap = ExportImportUtils.reverseMap(importData.getReplacementMap());
        Set importIds = this.objectLoaderFromDiskService.getListOfObjects(path, ExportImportDirectory.class).keySet();
        List eiFiles = this.loadConfiguration(importData, path);
        for (ExportImportFile eiFile : eiFiles) {
            try {
                this.loadFile(projectConfiguration, eiFile, existingIdToDirectory, reverseReplacementMap);
            }
            catch (MiaImportParentDirectoryNotFound e) {
                if (importIds.contains(eiFile.getDirectory())) continue;
                throw e;
            }
            finally {
                validationIds.add(eiFile.getId());
            }
        }
        return validationIds;
    }

    private ProjectFile loadFile(ProjectConfiguration projectConfiguration, ExportImportFile exportImportFile, Map<UUID, ProjectDirectory> existingIdToDirectory, Map<UUID, UUID> reverseReplaceMap) {
        ProjectDirectory parent = null;
        UUID parentId = exportImportFile.getDirectory();
        if (Objects.nonNull(parentId) && Objects.isNull(parent = existingIdToDirectory.getOrDefault(parentId, existingIdToDirectory.get(reverseReplaceMap.get(parentId))))) {
            throw new MiaImportParentDirectoryNotFound("file", exportImportFile.getName());
        }
        ProjectFile result = this.toEntity(projectConfiguration, exportImportFile);
        result.setDirectory(parent);
        return result;
    }

    private ProjectFile validateDuplicateFile(ProjectConfiguration projectConfiguration, ProjectFile importFile, Map<UUID, Map<String, ProjectFile>> folderIdWithEntryNames) {
        ProjectFile duplicateFile;
        boolean duplicateFileInFolder;
        UUID parentId = ExportImportUtils.getFolderId(importFile.getDirectory());
        Map<String, ProjectFile> namesInCurrentFolder = folderIdWithEntryNames.get(parentId);
        boolean folderExist = Objects.nonNull(namesInCurrentFolder);
        if (folderExist && (duplicateFileInFolder = Objects.nonNull(duplicateFile = namesInCurrentFolder.get(importFile.getName())))) {
            duplicateFile.setName(ExportImportUtils.generateCopyEntryName(duplicateFile.getName()));
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.gridFsService.rename(duplicateFile);
                this.fileConfigurationRepository.save(duplicateFile);
                return projectConfiguration;
            }, true);
        }
        return importFile;
    }

    @Override
    @Transactional
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        List<ProjectFile> loadedFiles = this.loadFiles(projectConfiguration, importData, path);
        this.mergeImportedFilesWithExisting(projectConfiguration, loadedFiles);
    }

    @NotNull
    private List<ProjectFile> loadFiles(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        Map<UUID, ProjectDirectory> existingIdToDirectory = ExportImportUtils.createMapIdToExistingDirectory(projectConfiguration);
        Map reverseReplacementMap = ExportImportUtils.reverseMap(importData.getReplacementMap());
        Map<UUID, Map<String, ProjectFile>> folderIdWithEntryNames = ExportImportUtils.createMapParentIdToFileNames(projectConfiguration);
        return this.loadConfiguration(importData, path).stream().map(eiFile -> this.loadFile(projectConfiguration, (ExportImportFile)eiFile, existingIdToDirectory, reverseReplacementMap)).map(importFile -> this.validateDuplicateFile(projectConfiguration, (ProjectFile)importFile, folderIdWithEntryNames)).map(importFile -> this.saveImportedFileToGridFs(projectConfiguration.getProjectId(), (ProjectFile)importFile, path)).collect(Collectors.toList());
    }

    private void mergeImportedFilesWithExisting(ProjectConfiguration projectConfiguration, List<ProjectFile> loadedFiles) {
        Map<UUID, ProjectFile> existingIdToFile = ExportImportUtils.createMapIdToExistingFile(projectConfiguration);
        for (ProjectFile importFile : loadedFiles) {
            this.mergeFile(projectConfiguration, importFile, existingIdToFile);
        }
    }

    private void mergeFile(ProjectConfiguration projectConfiguration, ProjectFile importFile, Map<UUID, ProjectFile> existingIdToFile) {
        ProjectFile conflictingFile = existingIdToFile.getOrDefault(importFile.getId(), existingIdToFile.get(importFile.getSourceId()));
        if (Objects.nonNull(conflictingFile)) {
            conflictingFile.setName(importFile.getName());
            conflictingFile.setSourceId(importFile.getSourceId());
            conflictingFile.setLastUpdateBy(importFile.getLastUpdateBy());
            conflictingFile.setLastUpdateWhen(importFile.getLastUpdateWhen());
            conflictingFile.setSize(importFile.getSize());
            conflictingFile.setGridFsObjectId(importFile.getGridFsObjectId());
            Optional.ofNullable(conflictingFile.getDirectory()).ifPresent(parent -> parent.getFiles().remove(conflictingFile));
            Optional.ofNullable(importFile.getDirectory()).ifPresent(parent -> parent.getFiles().add(conflictingFile));
            conflictingFile.setDirectory(importFile.getDirectory());
        } else {
            Optional.ofNullable(importFile.getDirectory()).map(ProjectDirectory::getFiles).ifPresent(f -> f.add(importFile));
            projectConfiguration.getFiles().add(importFile);
        }
    }

    private ProjectFile saveImportedFileToGridFs(UUID projectId, ProjectFile file, Path path) {
        FileMetaData metaData = new FileMetaData(projectId, Paths.get(ProjectFileType.MIA_FILE_TYPE_PROJECT.name(), new String[0]).resolve(file.getPathFile()).toString(), ProjectFileType.MIA_FILE_TYPE_PROJECT);
        File miaFilePath = path.resolve(ExportImportEntities.GRID_FS_FILE.getValue()).resolve(Optional.ofNullable(file.getSourceId()).orElse(file.getId()).toString()).resolve(file.getName()).toFile();
        String gridFsId = this.gridFsService.uploadFile(metaData, miaFilePath).toString();
        file.setGridFsObjectId(gridFsId);
        long size = this.gridFsService.getFile(file.getGridFsObjectId()).map(GridFSFile::getLength).orElse(0L);
        file.setSize(size);
        return file;
    }
}

