/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.model.configuration.HeaderConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportHeaderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportLoaderHeaderConfiguration
extends ImportLoader<ExportImportEntities, HeaderConfiguration, ExportImportHeaderConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderHeaderConfiguration.class);

    public ImportLoaderHeaderConfiguration(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        super(objectLoaderFromDiskService);
    }

    @Override
    public Class<ExportImportHeaderConfiguration> getClazz() {
        return ExportImportHeaderConfiguration.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_HEADER_CONFIGURATION;
    }

    @Override
    public HeaderConfiguration toEntity(ProjectConfiguration projectConfig, ExportImportHeaderConfiguration dto) {
        return HeaderConfiguration.builder().projectId(projectConfig.getProjectId()).showGenevaDateBlock(dto.isShowGenevaDateBlock()).showWorkingDirectory(dto.isShowWorkingDirectory()).showResetDbCache(dto.isShowResetDbCache()).showUpdateConfig(dto.isShowUpdateConfig()).showTestData(dto.isShowTestData()).showTimeShifting(dto.isShowTimeShifting()).exportToggleDefaultPosition(dto.isExportToggleDefaultPosition()).enableUpdateFlowJsonConfig(dto.isEnableUpdateFlowJsonConfig()).workingDirectory(dto.getWorkingDirectory()).switchers(dto.getSwitchers()).projectConfiguration(projectConfig).build();
    }

    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        return Collections.emptyList();
    }

    @Override
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        List configurations = this.loadConfiguration(importData, path);
        if (!configurations.isEmpty()) {
            ExportImportHeaderConfiguration configuration = (ExportImportHeaderConfiguration)configurations.get(0);
            projectConfiguration.setHeaderConfiguration(this.toEntity(projectConfiguration, configuration));
        }
    }
}

