/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.ei.service.AtpImportStrategy;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.configuration.SectionNotFoundException;
import org.qubership.atp.mia.exceptions.ei.MiaImportSectionException;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportIdentifier;
import org.qubership.atp.mia.model.ei.ExportImportSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportLoaderSection
extends ImportLoader<ExportImportEntities, SectionConfiguration, ExportImportSection> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderSection.class);

    public ImportLoaderSection(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        super(objectLoaderFromDiskService);
    }

    @Override
    public Class<ExportImportSection> getClazz() {
        return ExportImportSection.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_SECTION;
    }

    @Override
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        ArrayList loadedSections = new ArrayList();
        List importSections = this.loadConfiguration(importData, path);
        importSections.forEach(s -> this.loadSection(projectConfiguration, loadedSections, importSections, (ExportImportSection)s));
        loadedSections.forEach(s -> this.mergeSectionOrAdd(projectConfiguration, (SectionConfiguration)s, (List<SectionConfiguration>)new ArrayList<SectionConfiguration>()));
    }

    @Override
    public SectionConfiguration toEntity(ProjectConfiguration projectConfiguration, ExportImportSection exportImportSection) {
        return ((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)((SectionConfiguration.SectionConfigurationBuilder)new SectionConfiguration().toBuilder()).id(exportImportSection.getId())).name(exportImportSection.getName())).sourceId(exportImportSection.getSourceId())).parentSection(null)).sections(new ArrayList<SectionConfiguration>())).processes(new ArrayList<ProcessConfiguration>())).compounds(new ArrayList<CompoundConfiguration>())).build();
    }

    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        List importSections = this.loadConfiguration(importData, path);
        importSections.forEach(s -> this.loadSection(projectConfiguration, (List<SectionConfiguration>)new ArrayList<SectionConfiguration>(), importSections, (ExportImportSection)s));
        return importSections.stream().map(ExportImportIdentifier::getId).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadSection(ProjectConfiguration projectConfiguration, List<SectionConfiguration> loadedSections, List<ExportImportSection> importSections, ExportImportSection importSection) {
        if (!loadedSections.stream().noneMatch(s -> importSection.getId().equals(s.getId()))) return;
        if (importSection.getParentSection() != null) {
            Optional<SectionConfiguration> parentSectionOptional = loadedSections.stream().filter(s -> importSection.getParentSection().equals(s.getId())).findAny();
            if (parentSectionOptional.isPresent()) {
                SectionConfiguration loadedSection = this.toEntity(projectConfiguration, importSection);
                loadedSection.setParentSection(parentSectionOptional.get());
                parentSectionOptional.get().addSection(loadedSection);
                loadedSections.add(loadedSection);
                return;
            } else {
                SectionConfiguration loadedSection;
                Optional<ExportImportSection> importSectionOptional = importSections.stream().filter(s -> importSection.getParentSection().equals(s.getId())).findAny();
                if (importSectionOptional.isPresent()) {
                    this.loadSection(projectConfiguration, loadedSections, importSections, importSectionOptional.get());
                    parentSectionOptional = loadedSections.stream().filter(s -> importSection.getParentSection().equals(s.getId())).findAny();
                    if (parentSectionOptional.isPresent()) {
                        loadedSection = this.toEntity(projectConfiguration, importSection);
                        loadedSection.setParentSection(parentSectionOptional.get());
                        parentSectionOptional.get().addSection(loadedSection);
                        loadedSections.add(loadedSection);
                    }
                }
                if (parentSectionOptional.isPresent()) return;
                parentSectionOptional = projectConfiguration.getSections().stream().filter(s -> importSection.getParentSection().equals(s.getId())).findAny();
                if (!parentSectionOptional.isPresent()) throw new MiaImportSectionException(importSection);
                loadedSection = this.toEntity(projectConfiguration, importSection);
                loadedSection.setParentSection(parentSectionOptional.get());
                loadedSections.add(loadedSection);
            }
            return;
        } else {
            loadedSections.add(this.toEntity(projectConfiguration, importSection));
        }
    }

    private SectionConfiguration mergeSectionOrAdd(ProjectConfiguration projectConfiguration, SectionConfiguration section, List<SectionConfiguration> mergedSections) {
        return mergedSections.stream().filter(s -> s.getId().equals(section.getId())).findFirst().orElseGet(() -> section.getSourceId() != null ? this.mergeSectionOrAdd(projectConfiguration, section, section.getSourceId(), mergedSections) : this.mergeSectionOrAdd(projectConfiguration, section, section.getId(), mergedSections));
    }

    private SectionConfiguration mergeSectionOrAdd(ProjectConfiguration projectConfiguration, SectionConfiguration section, UUID sectionId, List<SectionConfiguration> mergedSections) {
        boolean duplicateName;
        Optional<SectionConfiguration> realSectionOptional = projectConfiguration.getSections().stream().filter(realS -> sectionId.equals(realS.getId()) || sectionId.equals(realS.getSourceId())).findFirst();
        if (realSectionOptional.isPresent()) {
            SectionConfiguration realSection = realSectionOptional.get();
            realSection.setName(section.getName());
            realSection.setSourceId(section.getSourceId());
            if (section.getParentSection() != null) {
                SectionConfiguration parentSectionBefore = realSection.getParentSection();
                SectionConfiguration parentSectionAfter = this.mergeSectionOrAdd(projectConfiguration, section.getParentSection(), mergedSections);
                SectionConfiguration sectionConfiguration = parentSectionAfter = parentSectionAfter != null ? parentSectionAfter : projectConfiguration.getSections().stream().filter(s -> section.getParentSection().getId().equals(s.getId())).findAny().orElseThrow(() -> new SectionNotFoundException(section.getParentSection().getId()));
                if (parentSectionBefore != null && !parentSectionBefore.getId().equals(parentSectionAfter.getId())) {
                    realSection.setParentSection(parentSectionAfter);
                    parentSectionAfter.addSection(realSection);
                    parentSectionBefore.getSections().remove(realSection);
                }
            } else {
                realSection.setParentSection(null);
            }
            mergedSections.add(realSection);
            return realSection;
        }
        section.setProjectConfiguration(projectConfiguration);
        projectConfiguration.getSections().add(section);
        mergedSections.add(section);
        if (section.getParentSection() != null) {
            SectionConfiguration parentSection = this.mergeSectionOrAdd(projectConfiguration, section.getParentSection(), mergedSections);
            parentSection = parentSection != null ? parentSection : projectConfiguration.getSections().stream().filter(s -> section.getParentSection().getId().equals(s.getId())).findAny().orElseThrow(() -> new SectionNotFoundException(section.getParentSection().getId()));
            parentSection.addSection(section);
            duplicateName = parentSection.getSections().stream().anyMatch(s -> section.getName().equals(s.getName()) && !section.getId().equals(s.getId()));
        } else {
            duplicateName = projectConfiguration.getRootSections().stream().anyMatch(s -> section.getName().equals(s.getName()) && !section.getId().equals(s.getId()));
        }
        if (duplicateName) {
            section.setName(section.getName() + "_ImportConflict_" + AtpImportStrategy.IMPORT_TIMESTAMP.get());
        }
        return section;
    }
}

