/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.service;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.dto.validation.MessageType;
import org.qubership.atp.ei.node.dto.validation.UserMessage;
import org.qubership.atp.integration.configuration.model.notification.Notification;
import org.qubership.atp.integration.configuration.service.NotificationService;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.ei.service.ImportStrategy;
import org.qubership.atp.mia.exceptions.ei.MiaImportTypeNotSupportException;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AtpImportStrategy
implements ImportStrategy {
    private static final Logger log = LoggerFactory.getLogger(AtpImportStrategy.class);
    public static ThreadLocal<Long> IMPORT_TIMESTAMP = new ThreadLocal();
    private final List<ImportLoader> importLoaders;
    private final ProjectConfigurationService projectConfigurationService;
    private final NotificationService notificationService;

    @Override
    public ExportFormat getFormat() {
        return ExportFormat.ATP;
    }

    @Override
    public void miaImport(ExportImportData importData, Path path) {
        try {
            IMPORT_TIMESTAMP.set(System.currentTimeMillis());
            ProjectConfiguration projectConfiguration = this.projectConfigurationService.getConfiguration(importData.getProjectId());
            if (projectConfiguration.getGitUrl() == null || projectConfiguration.getGitUrl().trim().isEmpty()) {
                Path sectionPath = path.resolve(ExportImportEntities.MIA_SECTION.getValue());
                this.getImportLoader(ExportImportEntities.MIA_SECTION).importEntity(projectConfiguration, importData, sectionPath);
                this.getImportLoader(ExportImportEntities.MIA_PROCESSES).importEntity(projectConfiguration, importData, sectionPath);
                this.getImportLoader(ExportImportEntities.MIA_COMPOUNDS).importEntity(projectConfiguration, importData, sectionPath);
                Path filesPath = path.resolve(ExportImportEntities.MIA_FILES.getValue());
                this.getImportLoader(ExportImportEntities.MIA_DIRECTORY).importEntity(projectConfiguration, importData, filesPath);
                this.getImportLoader(ExportImportEntities.MIA_FILES).importEntity(projectConfiguration, importData, filesPath);
                Path projectConfigurationPath = path.resolve(ExportImportEntities.MIA_PROJECT_CONFIGURATION.getValue());
                this.getImportLoader(ExportImportEntities.MIA_COMMON_CONFIGURATION).importEntity(projectConfiguration, importData, projectConfigurationPath);
                this.getImportLoader(ExportImportEntities.MIA_HEADER_CONFIGURATION).importEntity(projectConfiguration, importData, projectConfigurationPath);
                this.getImportLoader(ExportImportEntities.MIA_POT_HEADER_CONFIGURATION).importEntity(projectConfiguration, importData, projectConfigurationPath);
                log.info("Save configuration after import");
                this.projectConfigurationService.updateProjectWithReplicationOff(projectConfiguration, true);
            } else {
                log.info("Skipping MIA import. {}", (Object)ErrorCodes.MIA_7008_IMPORT_GIT_ENABLED.getMessage(new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("Error during the import: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        finally {
            IMPORT_TIMESTAMP.remove();
        }
    }

    @Override
    public ValidationResult validateData(ExportImportData importData, Path path) {
        ArrayList<UserMessage> details = new ArrayList<UserMessage>();
        HashMap replacementMap = new HashMap(importData.getReplacementMap());
        ProjectConfiguration projectConfiguration = this.projectConfigurationService.getConfiguration(importData.getProjectId());
        if (projectConfiguration.getGitUrl() != null && !projectConfiguration.getGitUrl().trim().isEmpty()) {
            String message = ErrorCodes.MIA_7008_IMPORT_GIT_ENABLED.getMessage(new Object[0]);
            log.warn(message);
            details.add(new UserMessage(message));
            this.notificationService.sendNotification(new Notification(message, Notification.Type.WARNING, projectConfiguration.getProjectId()));
        } else {
            try {
                boolean isReplacement;
                Path sectionPath = path.resolve(ExportImportEntities.MIA_SECTION.getValue());
                HashSet<UUID> allIds = new HashSet<UUID>();
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_SECTION).validate(projectConfiguration, importData, sectionPath));
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_PROCESSES).validate(projectConfiguration, importData, sectionPath));
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_COMPOUNDS).validate(projectConfiguration, importData, sectionPath));
                Path filesPath = path.resolve(ExportImportEntities.MIA_FILES.getValue());
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_DIRECTORY).validate(projectConfiguration, importData, filesPath));
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_FILES).validate(projectConfiguration, importData, filesPath));
                Path projectConfigurationPath = path.resolve(ExportImportEntities.MIA_PROJECT_CONFIGURATION.getValue());
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_COMMON_CONFIGURATION).validate(projectConfiguration, importData, projectConfigurationPath));
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_HEADER_CONFIGURATION).validate(projectConfiguration, importData, projectConfigurationPath));
                allIds.addAll(this.getImportLoader(ExportImportEntities.MIA_POT_HEADER_CONFIGURATION).validate(projectConfiguration, importData, projectConfigurationPath));
                boolean bl = isReplacement = importData.isCreateNewProject() || importData.isInterProjectImport();
                if (isReplacement) {
                    allIds.forEach(id -> replacementMap.put(id, UUID.randomUUID()));
                }
                log.info("Validation complete ids {} be replaced", (Object)(isReplacement ? "will" : "won't"));
            }
            catch (Exception e) {
                log.error("Error during import", (Throwable)e);
                UserMessage message = new UserMessage(e.getMessage());
                message.setMessageType(MessageType.ERROR);
                details.add(message);
            }
        }
        return new ValidationResult(details, replacementMap);
    }

    private ImportLoader getImportLoader(@NotNull ExportImportEntities type) throws MiaImportTypeNotSupportException {
        return this.importLoaders.stream().filter(importLoader -> type.equals(importLoader.getEntityType())).findFirst().orElseThrow(() -> new MiaImportTypeNotSupportException(type.name()));
    }

    public AtpImportStrategy(List<ImportLoader> importLoaders, ProjectConfigurationService projectConfigurationService, NotificationService notificationService) {
        this.importLoaders = importLoaders;
        this.projectConfigurationService = projectConfigurationService;
        this.notificationService = notificationService;
    }
}

