/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.exceptions;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR, reason="MIA-0000")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
public class MiaException
extends AtpException {
    private static final Logger log = LoggerFactory.getLogger(MiaException.class);
    private String reason = "MIA-0000";

    public MiaException(String message) {
        super(message);
        log.error(message);
    }

    public MiaException(Exception e) {
        super(e.getMessage());
        log.error(this.reason, (Throwable)e);
    }

    public MiaException(ErrorCodes errorCodes, Object ... args) {
        super(errorCodes.getMessage(args));
        this.reason = errorCodes.getCode();
        if (args != null && args.length > 0 && args[args.length - 1] instanceof Exception) {
            log.error(errorCodes.getMessage(args), args[args.length - 1]);
        } else {
            log.error(errorCodes.getMessage(args));
        }
    }

    public String getLocalizedMessage() {
        return null;
    }

    public StackTraceElement[] getStackTrace() {
        return new StackTraceElement[0];
    }

    public String getReason() {
        return this.reason == null ? "MIA-0000" : this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

