/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.exceptions.history;

import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.qubership.atp.mia.exceptions.MiaException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR, reason="MIA-2061")
public class MiaJaversReferenceInvalidException
extends MiaException {
    public static final String DEFAULT_MESSAGE = "Error while working with history references";
    private Set<ConstraintViolation<Object>> violations;

    public MiaJaversReferenceInvalidException(Set<ConstraintViolation<Object>> violations) {
        super(DEFAULT_MESSAGE);
        this.violations = violations;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        this.violations.stream().map(violation -> String.format(violation.getMessage(), Objects.nonNull(violation.getPropertyPath()) ? violation.getPropertyPath().toString() : "", Objects.nonNull(violation.getInvalidValue()) ? violation.getInvalidValue().toString() : "")).forEach(violation -> sb.append((String)violation).append(" "));
        return sb.toString();
    }
}

