/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.listeners;

import org.qubership.atp.mia.kafka.model.notification.EnvironmentUpdateEvent;
import org.qubership.atp.mia.service.cache.MiaCacheService;
import org.qubership.atp.mia.service.execution.SshExecutionHelperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, havingValue="true")
public class EnvironmentUpdateListener {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentUpdateListener.class);
    private final MiaCacheService miaCacheService;
    private final SshExecutionHelperService sshExecutionHelperService;
    private final CacheManager cacheManager;

    @KafkaListener(id="${kafka.env.update.listen.group}", groupId="${kafka.env.update.listen.group}", topics={"${kafka.env.update.listen.topic}"}, containerFactory="environmentUpdateEventContainerFactory", autoStartup="true")
    public void listenToEnvironmentService(@Payload EnvironmentUpdateEvent event) {
        log.info("Environment Update Event Listened for project id : {}", (Object)event.getProjectId());
        this.miaCacheService.clearEnvironmentsCache(this.cacheManager, event.getProjectId());
        this.sshExecutionHelperService.resetCache();
    }

    public EnvironmentUpdateListener(MiaCacheService miaCacheService, SshExecutionHelperService sshExecutionHelperService, CacheManager cacheManager) {
        this.miaCacheService = miaCacheService;
        this.sshExecutionHelperService = sshExecutionHelperService;
        this.cacheManager = cacheManager;
    }
}

