/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.listeners;

import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.qubership.atp.mia.service.SseEmitterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, havingValue="true")
public class MiaExecutionFinishListener {
    private static final Logger log = LoggerFactory.getLogger(MiaExecutionFinishListener.class);
    private static final String KAFKA_MIA_EXECUTION_FINISH_RESPONSE_LISTENER_ID = "miaExecutionFinishListener";
    private final SseEmitterService sseEmitterService;

    @KafkaListener(groupId="miaExecutionFinishListener_#{T(org.qubership.atp.mia.utils.PodNameUtils).getServicePodName()}", topics={"${kafka.mia.execution.finish.topic}"}, containerFactory="miaExecutionFinishKafkaContainerFactory")
    @Transactional
    public void listenItfLiteExecutionFinishEvent(@Payload ExecutionResponse payload) {
        log.debug("Start mia execution processing by event from kafka for sseId {}]", (Object)payload.getSseId());
        SseEmitter sseEmitter = this.sseEmitterService.getEmitter(payload.getSseId());
        if (sseEmitter != null) {
            this.sseEmitterService.sendEventWithExecutionResult(sseEmitter, payload);
        }
    }

    public MiaExecutionFinishListener(SseEmitterService sseEmitterService) {
        this.sseEmitterService = sseEmitterService;
    }
}

