/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.listeners;

import org.qubership.atp.mia.kafka.model.notification.ProjectEvent;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Caching;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, havingValue="true")
public class ProjectEventKafkaListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectEventKafkaListener.class);
    private final ProjectConfigurationService projectConfigService;

    @Caching(put={@CachePut(value={"ATP_MIA_PROJECT_NAME"}, key="#projectEvent.projectId", condition="#projectEvent!=null&&#projectEvent.projectId!=null")})
    @KafkaListener(id="${kafka.catalog.notification.group}", groupId="${kafka.catalog.notification.group}", topics={"${kafka.catalog.notification.topic:catalog_notification_topic}"}, containerFactory="catalogProjectEventContainerFactory", autoStartup="true")
    public void listen(ProjectEvent projectEvent) {
        switch (projectEvent.getType()) {
            case CREATE: {
                this.projectConfigService.getConfigByProjectId(projectEvent.getProjectId());
                break;
            }
            case UPDATE: {
                ProjectConfiguration config = this.projectConfigService.getConfigByProjectId(projectEvent.getProjectId());
                config.setProjectName(projectEvent.getProjectName());
                try {
                    this.projectConfigService.updateProject(config, false);
                }
                catch (Exception e) {
                    log.error("Receive message from kafka about update configuration but something goes wrong during save: {}", (Throwable)e);
                }
                break;
            }
            case DELETE: {
                this.projectConfigService.removeProject(projectEvent.getProjectId(), true);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type of events " + (Object)((Object)projectEvent.getType()));
            }
        }
    }

    public ProjectEventKafkaListener(ProjectConfigurationService projectConfigService) {
        this.projectConfigService = projectConfigService;
    }
}

