/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model;

import java.util.concurrent.TimeUnit;

public enum CacheKeys {
    PROJECTNAME_KEY("ATP_MIA_PROJECT_NAME", 24, TimeUnit.DAYS, CacheGroups.PROJECTS, true),
    CONFIGURATION_KEY("ATP_MIA_CONFIGURATION", 5, TimeUnit.MINUTES, CacheGroups.PROJECTS, true),
    ENVIRONMENTS_KEY("ATP_MIA_ENVIRONMENTS", 1, TimeUnit.HOURS, CacheGroups.ENVIRONMENT, true),
    ENVIRONMENTS_BY_NAME_KEY("ATP_MIA_ENVIRONMENTS_BY_NAME", 1, TimeUnit.HOURS, CacheGroups.ENVIRONMENT, true),
    ENVIRONMENTSFULL_KEY("ATP_MIA_ENVIRONMENTSFULL", 10, TimeUnit.MINUTES, CacheGroups.ENVIRONMENT, true),
    SYSTEM_NAMES("ATP_MIA_SYSTEM_NAMES", 20, TimeUnit.MINUTES, CacheGroups.SYSTEMS, false),
    MIA_PROJECTS_KEY("ATP_MIA_PROJECTS", 2, TimeUnit.HOURS, CacheGroups.ENVIRONMENT, false),
    AUTH_PROJECTS_KEY("projects", 2, TimeUnit.MINUTES, CacheGroups.PROJECTS, true),
    ATP_MACROS_KEY("ATP_MIA_MACROS", 5, TimeUnit.MINUTES, CacheGroups.MACROS, true);

    private final String key;
    private final int timeToLive;
    private final TimeUnit timeUnit;
    private final CacheGroups cacheGroup;
    private final boolean isKeyContainProjectId;

    private CacheKeys(String key, int timeToLive, TimeUnit timeUnit, CacheGroups cacheGroup, boolean isCacheContainsProjectId) {
        this.key = key;
        this.timeToLive = timeToLive;
        this.timeUnit = timeUnit;
        this.cacheGroup = cacheGroup;
        this.isKeyContainProjectId = isCacheContainsProjectId;
    }

    public int getTtlInSeconds() {
        switch (this.timeUnit) {
            case SECONDS: {
                return this.timeToLive;
            }
            case MINUTES: {
                return 60 * this.timeToLive;
            }
            case HOURS: {
                return 3600 * this.timeToLive;
            }
            case DAYS: {
                return 86400 * this.timeToLive;
            }
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public CacheGroups getCacheGroup() {
        return this.cacheGroup;
    }

    public boolean isKeyContainProjectId() {
        return this.isKeyContainProjectId;
    }

    public static enum CacheGroups {
        PROJECTS,
        ENVIRONMENT,
        SYSTEMS,
        MACROS,
        CONFIGURATION;

    }

    public static class Constants {
        public static final String PROJECTNAME_KEY = "ATP_MIA_PROJECT_NAME";
        public static final String CONFIGURATION_KEY = "ATP_MIA_CONFIGURATION";
        public static final String ENVIRONMENTS_KEY = "ATP_MIA_ENVIRONMENTS";
        public static final String ENVIRONMENTS_BY_NAME_KEY = "ATP_MIA_ENVIRONMENTS_BY_NAME";
        public static final String ENVIRONMENTSFULL_KEY = "ATP_MIA_ENVIRONMENTSFULL";
        public static final String SYSTEM_NAMES = "ATP_MIA_SYSTEM_NAMES";
        public static final String MIA_PROJECTS_KEY = "ATP_MIA_PROJECTS";
        public static final String AUTH_PROJECTS_KEY = "projects";
        public static final String ATP_MACROS_KEY = "ATP_MIA_MACROS";
    }
}

