/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ContentType {
    js(Arrays.asList("application/javascript"), true, true),
    ogg(Arrays.asList("application/ogg"), false, false),
    pdf(Arrays.asList("application/pdf"), false, false),
    json(Arrays.asList("application/json"), true, true),
    zip(Arrays.asList("application/zip"), false, false),
    xml(Arrays.asList("application/xml", "text/xml"), true, true),
    gif(Arrays.asList("image/gif"), false, false),
    jpeg(Arrays.asList("image/jpeg"), false, false),
    png(Arrays.asList("image/png"), false, false),
    tiff(Arrays.asList("image/tiff"), false, false),
    svg(Arrays.asList("image/svg+xml"), false, false),
    doc(Arrays.asList("application/msword"), false, false),
    xls(Arrays.asList("application/vnd.ms-excel"), false, false),
    txt(Arrays.asList("text/plain"), true, true),
    undefined(Arrays.asList("undefined"), false, false);

    private static final Logger log;
    private List<String> mimeType;
    private boolean display;
    private boolean textFormat;

    private ContentType(List<String> mimeType, boolean display, boolean textFormat) {
        this.mimeType = mimeType;
        this.display = display;
        this.textFormat = textFormat;
    }

    public static ContentType getType(String value) {
        for (ContentType type : ContentType.values()) {
            for (String mimeType : type.mimeType) {
                if (!mimeType.equals(value) && (Strings.isEmpty((CharSequence)value) || !mimeType.matches(".*?\\b" + value + "\\b.*?") && !value.matches(".*?\\b" + mimeType + "\\b.*?"))) continue;
                return type;
            }
        }
        Utils.error(log, ErrorCodes.MIA_1410_REST_CONTENT_TYPE_NOT_SUPPORT, value);
        return undefined;
    }

    public String getExtension() {
        return "." + this.name();
    }

    public boolean isDisplay() {
        return this.display;
    }

    public boolean isTextFormat() {
        return this.textFormat;
    }

    static {
        log = LoggerFactory.getLogger(ContentType.class);
    }
}

