/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;

@Entity
@Table(name="project_compounds_configuration")
public class CompoundConfiguration
extends DateAuditorEntity {
    private static final long serialVersionUID = -4706896104344439606L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    @DiffInclude
    private UUID id;
    @Column(name="source_id")
    private UUID sourceId;
    @Column(name="compound_name")
    @DiffInclude
    private String name;
    @Column(name="refer_to_input")
    @DiffInclude
    private String referToInput;
    @ManyToMany(targetEntity=ProcessConfiguration.class, cascade={CascadeType.MERGE})
    @JoinTable(name="project_compound_process_configuration", joinColumns={@JoinColumn(name="compound_id")}, inverseJoinColumns={@JoinColumn(name="process_id")})
    @OrderColumn(name="place")
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<ProcessConfiguration> processes = new ArrayList<ProcessConfiguration>();
    @ManyToMany(mappedBy="compounds", targetEntity=SectionConfiguration.class, cascade={CascadeType.MERGE})
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<SectionConfiguration> inSections = new ArrayList<SectionConfiguration>();
    @ManyToOne(targetEntity=ProjectConfiguration.class)
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;

    public void addProcess(ProcessConfiguration processConfiguration) {
        if (this.processes == null) {
            this.processes = new ArrayList<ProcessConfiguration>();
        }
        this.processes.add(processConfiguration);
    }

    @JsonSetter
    public void setProcesses(List<ProcessConfiguration> processes) {
        this.processes = processes;
    }

    protected CompoundConfiguration(CompoundConfigurationBuilder<?, ?> b) {
        super(b);
        this.id = ((CompoundConfigurationBuilder)b).id;
        this.sourceId = ((CompoundConfigurationBuilder)b).sourceId;
        this.name = ((CompoundConfigurationBuilder)b).name;
        this.referToInput = ((CompoundConfigurationBuilder)b).referToInput;
        this.processes = ((CompoundConfigurationBuilder)b).processes;
        this.inSections = ((CompoundConfigurationBuilder)b).inSections;
        this.projectConfiguration = ((CompoundConfigurationBuilder)b).projectConfiguration;
    }

    public static CompoundConfigurationBuilder<?, ?> builder() {
        return new CompoundConfigurationBuilderImpl();
    }

    public CompoundConfigurationBuilder<?, ?> toBuilder() {
        return new CompoundConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getReferToInput() {
        return this.referToInput;
    }

    public List<ProcessConfiguration> getProcesses() {
        return this.processes;
    }

    public List<SectionConfiguration> getInSections() {
        return this.inSections;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReferToInput(String referToInput) {
        this.referToInput = referToInput;
    }

    public void setInSections(List<SectionConfiguration> inSections) {
        this.inSections = inSections;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompoundConfiguration)) {
            return false;
        }
        CompoundConfiguration other = (CompoundConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$sourceId = this.getSourceId();
        UUID other$sourceId = other.getSourceId();
        return !(this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CompoundConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CompoundConfiguration(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", name=" + this.getName() + ", referToInput=" + this.getReferToInput() + ")";
    }

    public CompoundConfiguration(UUID id, UUID sourceId, String name, String referToInput, List<ProcessConfiguration> processes, List<SectionConfiguration> inSections, ProjectConfiguration projectConfiguration) {
        this.id = id;
        this.sourceId = sourceId;
        this.name = name;
        this.referToInput = referToInput;
        this.processes = processes;
        this.inSections = inSections;
        this.projectConfiguration = projectConfiguration;
    }

    public CompoundConfiguration() {
    }

    public static abstract class CompoundConfigurationBuilder<C extends CompoundConfiguration, B extends CompoundConfigurationBuilder<C, B>>
    extends DateAuditorEntity.DateAuditorEntityBuilder<C, B> {
        private UUID id;
        private UUID sourceId;
        private String name;
        private String referToInput;
        private List<ProcessConfiguration> processes;
        private List<SectionConfiguration> inSections;
        private ProjectConfiguration projectConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CompoundConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CompoundConfiguration instance, CompoundConfigurationBuilder<?, ?> b) {
            b.id(instance.id);
            b.sourceId(instance.sourceId);
            b.name(instance.name);
            b.referToInput(instance.referToInput);
            b.processes(instance.processes);
            b.inSections(instance.inSections);
            b.projectConfiguration(instance.projectConfiguration);
        }

        public B id(UUID id) {
            this.id = id;
            return (B)this.self();
        }

        public B sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B referToInput(String referToInput) {
            this.referToInput = referToInput;
            return (B)this.self();
        }

        public B processes(List<ProcessConfiguration> processes) {
            this.processes = processes;
            return (B)this.self();
        }

        public B inSections(List<SectionConfiguration> inSections) {
            this.inSections = inSections;
            return (B)this.self();
        }

        public B projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "CompoundConfiguration.CompoundConfigurationBuilder(super=" + super.toString() + ", id=" + this.id + ", sourceId=" + this.sourceId + ", name=" + this.name + ", referToInput=" + this.referToInput + ", processes=" + this.processes + ", inSections=" + this.inSections + ", projectConfiguration=" + this.projectConfiguration + ")";
        }
    }

    private static final class CompoundConfigurationBuilderImpl
    extends CompoundConfigurationBuilder<CompoundConfiguration, CompoundConfigurationBuilderImpl> {
        private CompoundConfigurationBuilderImpl() {
        }

        @Override
        protected CompoundConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public CompoundConfiguration build() {
            return new CompoundConfiguration(this);
        }
    }
}

