/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.Switcher;

@Entity
@Table(name="project_header_configuration")
@TypeDef(name="jsonb", typeClass=JsonBinaryType.class)
@Value
public class HeaderConfiguration
implements Serializable {
    private static final long serialVersionUID = -1708851849749487504L;
    @Id
    @Column(name="project_id")
    private UUID projectId;
    @Column(name="show_geneva_date_block")
    @DiffInclude
    private boolean showGenevaDateBlock;
    @Column(name="show_working_directory")
    @DiffInclude
    private boolean showWorkingDirectory;
    @Column(name="show_reset_db_cache")
    @DiffInclude
    private boolean showResetDbCache;
    @Column(name="show_update_config")
    @DiffInclude
    private boolean showUpdateConfig;
    @Column(name="show_test_data")
    @DiffInclude
    private boolean showTestData;
    @Column(name="show_time_shifting")
    @DiffInclude
    private boolean showTimeShifting;
    @Column(name="export_toggle_default_position")
    @DiffInclude
    private boolean exportToggleDefaultPosition;
    @Column(name="enable_update_flow_json_config")
    @DiffInclude
    private boolean enableUpdateFlowJsonConfig;
    @Column(name="working_directory")
    @DiffInclude
    private String workingDirectory;
    @Column(name="switchers", columnDefinition="jsonb")
    @Type(type="jsonb")
    @DiffInclude
    private List<Switcher> switchers;
    @Column(name="system_switchers", columnDefinition="jsonb")
    @Type(type="jsonb")
    @DiffIgnore
    private List<Switcher> systemSwitchers;
    @OneToOne(targetEntity=ProjectConfiguration.class, cascade={CascadeType.MERGE})
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;

    public static List<Switcher> defaultSystemSwitchers() {
        Switcher sw1 = new Switcher();
        sw1.setName("fullTraceMode");
        sw1.setDisplay("Full Trace On/Off");
        sw1.setActionType("SSH");
        sw1.setValue(false);
        sw1.setActionTrue("export TRACE_LEVEL=FULL\nexport TRACE_ALL=ON");
        sw1.setActionFalse(null);
        Switcher sw2 = new Switcher();
        sw2.setName("needDos2Unix");
        sw2.setDisplay("needDos2Unix");
        sw2.setValue(false);
        Switcher sw3 = new Switcher();
        sw3.setName("replaceFileOnUploadAttachment");
        sw3.setDisplay("Replace/Add timestamp on upload attachment");
        sw3.setValue(true);
        sw3.setActionTrue("replace");
        sw3.setActionFalse("add timestamp");
        Switcher sw4 = new Switcher();
        sw4.setName("stopOnFail");
        sw4.setDisplay("Stop compound if one of processes is fail");
        sw4.setValue(true);
        return Arrays.asList(sw1, sw2, sw3, sw4);
    }

    public void setSystemSwitchers(List<Switcher> systemSwitchers) {
        this.systemSwitchers.forEach(sw -> {
            Optional<Switcher> swConfig = systemSwitchers.stream().filter(swC -> swC.getName().equals(sw.getName())).findAny();
            if (swConfig.isPresent()) {
                sw.setValue(swConfig.get().isValue());
            }
        });
    }

    private static boolean $default$showGenevaDateBlock() {
        return true;
    }

    private static boolean $default$showWorkingDirectory() {
        return true;
    }

    private static boolean $default$showResetDbCache() {
        return false;
    }

    private static boolean $default$showUpdateConfig() {
        return true;
    }

    private static boolean $default$showTestData() {
        return false;
    }

    private static boolean $default$showTimeShifting() {
        return false;
    }

    private static boolean $default$exportToggleDefaultPosition() {
        return true;
    }

    private static boolean $default$enableUpdateFlowJsonConfig() {
        return true;
    }

    private static String $default$workingDirectory() {
        return "/tmp/TA/";
    }

    private static List<Switcher> $default$switchers() {
        return new ArrayList<Switcher>();
    }

    private static List<Switcher> $default$systemSwitchers() {
        return HeaderConfiguration.defaultSystemSwitchers();
    }

    public static HeaderConfigurationBuilder builder() {
        return new HeaderConfigurationBuilder();
    }

    public HeaderConfigurationBuilder toBuilder() {
        return new HeaderConfigurationBuilder().projectId(this.projectId).showGenevaDateBlock(this.showGenevaDateBlock).showWorkingDirectory(this.showWorkingDirectory).showResetDbCache(this.showResetDbCache).showUpdateConfig(this.showUpdateConfig).showTestData(this.showTestData).showTimeShifting(this.showTimeShifting).exportToggleDefaultPosition(this.exportToggleDefaultPosition).enableUpdateFlowJsonConfig(this.enableUpdateFlowJsonConfig).workingDirectory(this.workingDirectory).switchers(this.switchers).systemSwitchers(this.systemSwitchers).projectConfiguration(this.projectConfiguration);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public boolean isShowGenevaDateBlock() {
        return this.showGenevaDateBlock;
    }

    public boolean isShowWorkingDirectory() {
        return this.showWorkingDirectory;
    }

    public boolean isShowResetDbCache() {
        return this.showResetDbCache;
    }

    public boolean isShowUpdateConfig() {
        return this.showUpdateConfig;
    }

    public boolean isShowTestData() {
        return this.showTestData;
    }

    public boolean isShowTimeShifting() {
        return this.showTimeShifting;
    }

    public boolean isExportToggleDefaultPosition() {
        return this.exportToggleDefaultPosition;
    }

    public boolean isEnableUpdateFlowJsonConfig() {
        return this.enableUpdateFlowJsonConfig;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public List<Switcher> getSwitchers() {
        return this.switchers;
    }

    public List<Switcher> getSystemSwitchers() {
        return this.systemSwitchers;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setShowGenevaDateBlock(boolean showGenevaDateBlock) {
        this.showGenevaDateBlock = showGenevaDateBlock;
    }

    public void setShowWorkingDirectory(boolean showWorkingDirectory) {
        this.showWorkingDirectory = showWorkingDirectory;
    }

    public void setShowResetDbCache(boolean showResetDbCache) {
        this.showResetDbCache = showResetDbCache;
    }

    public void setShowUpdateConfig(boolean showUpdateConfig) {
        this.showUpdateConfig = showUpdateConfig;
    }

    public void setShowTestData(boolean showTestData) {
        this.showTestData = showTestData;
    }

    public void setShowTimeShifting(boolean showTimeShifting) {
        this.showTimeShifting = showTimeShifting;
    }

    public void setExportToggleDefaultPosition(boolean exportToggleDefaultPosition) {
        this.exportToggleDefaultPosition = exportToggleDefaultPosition;
    }

    public void setEnableUpdateFlowJsonConfig(boolean enableUpdateFlowJsonConfig) {
        this.enableUpdateFlowJsonConfig = enableUpdateFlowJsonConfig;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setSwitchers(List<Switcher> switchers) {
        this.switchers = switchers;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderConfiguration)) {
            return false;
        }
        HeaderConfiguration other = (HeaderConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShowGenevaDateBlock() != other.isShowGenevaDateBlock()) {
            return false;
        }
        if (this.isShowWorkingDirectory() != other.isShowWorkingDirectory()) {
            return false;
        }
        if (this.isShowResetDbCache() != other.isShowResetDbCache()) {
            return false;
        }
        if (this.isShowUpdateConfig() != other.isShowUpdateConfig()) {
            return false;
        }
        if (this.isShowTestData() != other.isShowTestData()) {
            return false;
        }
        if (this.isShowTimeShifting() != other.isShowTimeShifting()) {
            return false;
        }
        if (this.isExportToggleDefaultPosition() != other.isExportToggleDefaultPosition()) {
            return false;
        }
        if (this.isEnableUpdateFlowJsonConfig() != other.isEnableUpdateFlowJsonConfig()) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$workingDirectory = this.getWorkingDirectory();
        String other$workingDirectory = other.getWorkingDirectory();
        if (this$workingDirectory == null ? other$workingDirectory != null : !this$workingDirectory.equals(other$workingDirectory)) {
            return false;
        }
        List<Switcher> this$switchers = this.getSwitchers();
        List<Switcher> other$switchers = other.getSwitchers();
        if (this$switchers == null ? other$switchers != null : !((Object)this$switchers).equals(other$switchers)) {
            return false;
        }
        List<Switcher> this$systemSwitchers = this.getSystemSwitchers();
        List<Switcher> other$systemSwitchers = other.getSystemSwitchers();
        return !(this$systemSwitchers == null ? other$systemSwitchers != null : !((Object)this$systemSwitchers).equals(other$systemSwitchers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeaderConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowGenevaDateBlock() ? 79 : 97);
        result = result * 59 + (this.isShowWorkingDirectory() ? 79 : 97);
        result = result * 59 + (this.isShowResetDbCache() ? 79 : 97);
        result = result * 59 + (this.isShowUpdateConfig() ? 79 : 97);
        result = result * 59 + (this.isShowTestData() ? 79 : 97);
        result = result * 59 + (this.isShowTimeShifting() ? 79 : 97);
        result = result * 59 + (this.isExportToggleDefaultPosition() ? 79 : 97);
        result = result * 59 + (this.isEnableUpdateFlowJsonConfig() ? 79 : 97);
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : $workingDirectory.hashCode());
        List<Switcher> $switchers = this.getSwitchers();
        result = result * 59 + ($switchers == null ? 43 : ((Object)$switchers).hashCode());
        List<Switcher> $systemSwitchers = this.getSystemSwitchers();
        result = result * 59 + ($systemSwitchers == null ? 43 : ((Object)$systemSwitchers).hashCode());
        return result;
    }

    public String toString() {
        return "HeaderConfiguration(projectId=" + this.getProjectId() + ", showGenevaDateBlock=" + this.isShowGenevaDateBlock() + ", showWorkingDirectory=" + this.isShowWorkingDirectory() + ", showResetDbCache=" + this.isShowResetDbCache() + ", showUpdateConfig=" + this.isShowUpdateConfig() + ", showTestData=" + this.isShowTestData() + ", showTimeShifting=" + this.isShowTimeShifting() + ", exportToggleDefaultPosition=" + this.isExportToggleDefaultPosition() + ", enableUpdateFlowJsonConfig=" + this.isEnableUpdateFlowJsonConfig() + ", workingDirectory=" + this.getWorkingDirectory() + ", switchers=" + this.getSwitchers() + ", systemSwitchers=" + this.getSystemSwitchers() + ")";
    }

    public HeaderConfiguration() {
        this.showGenevaDateBlock = HeaderConfiguration.$default$showGenevaDateBlock();
        this.showWorkingDirectory = HeaderConfiguration.$default$showWorkingDirectory();
        this.showResetDbCache = HeaderConfiguration.$default$showResetDbCache();
        this.showUpdateConfig = HeaderConfiguration.$default$showUpdateConfig();
        this.showTestData = HeaderConfiguration.$default$showTestData();
        this.showTimeShifting = HeaderConfiguration.$default$showTimeShifting();
        this.exportToggleDefaultPosition = HeaderConfiguration.$default$exportToggleDefaultPosition();
        this.enableUpdateFlowJsonConfig = HeaderConfiguration.$default$enableUpdateFlowJsonConfig();
        this.workingDirectory = HeaderConfiguration.$default$workingDirectory();
        this.switchers = HeaderConfiguration.$default$switchers();
        this.systemSwitchers = HeaderConfiguration.$default$systemSwitchers();
    }

    public HeaderConfiguration(UUID projectId, boolean showGenevaDateBlock, boolean showWorkingDirectory, boolean showResetDbCache, boolean showUpdateConfig, boolean showTestData, boolean showTimeShifting, boolean exportToggleDefaultPosition, boolean enableUpdateFlowJsonConfig, String workingDirectory, List<Switcher> switchers, List<Switcher> systemSwitchers, ProjectConfiguration projectConfiguration) {
        this.projectId = projectId;
        this.showGenevaDateBlock = showGenevaDateBlock;
        this.showWorkingDirectory = showWorkingDirectory;
        this.showResetDbCache = showResetDbCache;
        this.showUpdateConfig = showUpdateConfig;
        this.showTestData = showTestData;
        this.showTimeShifting = showTimeShifting;
        this.exportToggleDefaultPosition = exportToggleDefaultPosition;
        this.enableUpdateFlowJsonConfig = enableUpdateFlowJsonConfig;
        this.workingDirectory = workingDirectory;
        this.switchers = switchers;
        this.systemSwitchers = systemSwitchers;
        this.projectConfiguration = projectConfiguration;
    }

    public static class HeaderConfigurationBuilder {
        private UUID projectId;
        private boolean showGenevaDateBlock$set;
        private boolean showGenevaDateBlock$value;
        private boolean showWorkingDirectory$set;
        private boolean showWorkingDirectory$value;
        private boolean showResetDbCache$set;
        private boolean showResetDbCache$value;
        private boolean showUpdateConfig$set;
        private boolean showUpdateConfig$value;
        private boolean showTestData$set;
        private boolean showTestData$value;
        private boolean showTimeShifting$set;
        private boolean showTimeShifting$value;
        private boolean exportToggleDefaultPosition$set;
        private boolean exportToggleDefaultPosition$value;
        private boolean enableUpdateFlowJsonConfig$set;
        private boolean enableUpdateFlowJsonConfig$value;
        private boolean workingDirectory$set;
        private String workingDirectory$value;
        private boolean switchers$set;
        private List<Switcher> switchers$value;
        private boolean systemSwitchers$set;
        private List<Switcher> systemSwitchers$value;
        private ProjectConfiguration projectConfiguration;

        HeaderConfigurationBuilder() {
        }

        public HeaderConfigurationBuilder projectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        public HeaderConfigurationBuilder showGenevaDateBlock(boolean showGenevaDateBlock) {
            this.showGenevaDateBlock$value = showGenevaDateBlock;
            this.showGenevaDateBlock$set = true;
            return this;
        }

        public HeaderConfigurationBuilder showWorkingDirectory(boolean showWorkingDirectory) {
            this.showWorkingDirectory$value = showWorkingDirectory;
            this.showWorkingDirectory$set = true;
            return this;
        }

        public HeaderConfigurationBuilder showResetDbCache(boolean showResetDbCache) {
            this.showResetDbCache$value = showResetDbCache;
            this.showResetDbCache$set = true;
            return this;
        }

        public HeaderConfigurationBuilder showUpdateConfig(boolean showUpdateConfig) {
            this.showUpdateConfig$value = showUpdateConfig;
            this.showUpdateConfig$set = true;
            return this;
        }

        public HeaderConfigurationBuilder showTestData(boolean showTestData) {
            this.showTestData$value = showTestData;
            this.showTestData$set = true;
            return this;
        }

        public HeaderConfigurationBuilder showTimeShifting(boolean showTimeShifting) {
            this.showTimeShifting$value = showTimeShifting;
            this.showTimeShifting$set = true;
            return this;
        }

        public HeaderConfigurationBuilder exportToggleDefaultPosition(boolean exportToggleDefaultPosition) {
            this.exportToggleDefaultPosition$value = exportToggleDefaultPosition;
            this.exportToggleDefaultPosition$set = true;
            return this;
        }

        public HeaderConfigurationBuilder enableUpdateFlowJsonConfig(boolean enableUpdateFlowJsonConfig) {
            this.enableUpdateFlowJsonConfig$value = enableUpdateFlowJsonConfig;
            this.enableUpdateFlowJsonConfig$set = true;
            return this;
        }

        public HeaderConfigurationBuilder workingDirectory(String workingDirectory) {
            this.workingDirectory$value = workingDirectory;
            this.workingDirectory$set = true;
            return this;
        }

        public HeaderConfigurationBuilder switchers(List<Switcher> switchers) {
            this.switchers$value = switchers;
            this.switchers$set = true;
            return this;
        }

        public HeaderConfigurationBuilder systemSwitchers(List<Switcher> systemSwitchers) {
            this.systemSwitchers$value = systemSwitchers;
            this.systemSwitchers$set = true;
            return this;
        }

        public HeaderConfigurationBuilder projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return this;
        }

        public HeaderConfiguration build() {
            boolean showGenevaDateBlock$value = this.showGenevaDateBlock$value;
            if (!this.showGenevaDateBlock$set) {
                showGenevaDateBlock$value = HeaderConfiguration.$default$showGenevaDateBlock();
            }
            boolean showWorkingDirectory$value = this.showWorkingDirectory$value;
            if (!this.showWorkingDirectory$set) {
                showWorkingDirectory$value = HeaderConfiguration.$default$showWorkingDirectory();
            }
            boolean showResetDbCache$value = this.showResetDbCache$value;
            if (!this.showResetDbCache$set) {
                showResetDbCache$value = HeaderConfiguration.$default$showResetDbCache();
            }
            boolean showUpdateConfig$value = this.showUpdateConfig$value;
            if (!this.showUpdateConfig$set) {
                showUpdateConfig$value = HeaderConfiguration.$default$showUpdateConfig();
            }
            boolean showTestData$value = this.showTestData$value;
            if (!this.showTestData$set) {
                showTestData$value = HeaderConfiguration.$default$showTestData();
            }
            boolean showTimeShifting$value = this.showTimeShifting$value;
            if (!this.showTimeShifting$set) {
                showTimeShifting$value = HeaderConfiguration.$default$showTimeShifting();
            }
            boolean exportToggleDefaultPosition$value = this.exportToggleDefaultPosition$value;
            if (!this.exportToggleDefaultPosition$set) {
                exportToggleDefaultPosition$value = HeaderConfiguration.$default$exportToggleDefaultPosition();
            }
            boolean enableUpdateFlowJsonConfig$value = this.enableUpdateFlowJsonConfig$value;
            if (!this.enableUpdateFlowJsonConfig$set) {
                enableUpdateFlowJsonConfig$value = HeaderConfiguration.$default$enableUpdateFlowJsonConfig();
            }
            String workingDirectory$value = this.workingDirectory$value;
            if (!this.workingDirectory$set) {
                workingDirectory$value = HeaderConfiguration.$default$workingDirectory();
            }
            List switchers$value = this.switchers$value;
            if (!this.switchers$set) {
                switchers$value = HeaderConfiguration.$default$switchers();
            }
            List systemSwitchers$value = this.systemSwitchers$value;
            if (!this.systemSwitchers$set) {
                systemSwitchers$value = HeaderConfiguration.$default$systemSwitchers();
            }
            return new HeaderConfiguration(this.projectId, showGenevaDateBlock$value, showWorkingDirectory$value, showResetDbCache$value, showUpdateConfig$value, showTestData$value, showTimeShifting$value, exportToggleDefaultPosition$value, enableUpdateFlowJsonConfig$value, workingDirectory$value, switchers$value, systemSwitchers$value, this.projectConfiguration);
        }

        public String toString() {
            return "HeaderConfiguration.HeaderConfigurationBuilder(projectId=" + this.projectId + ", showGenevaDateBlock$value=" + this.showGenevaDateBlock$value + ", showWorkingDirectory$value=" + this.showWorkingDirectory$value + ", showResetDbCache$value=" + this.showResetDbCache$value + ", showUpdateConfig$value=" + this.showUpdateConfig$value + ", showTestData$value=" + this.showTestData$value + ", showTimeShifting$value=" + this.showTimeShifting$value + ", exportToggleDefaultPosition$value=" + this.exportToggleDefaultPosition$value + ", enableUpdateFlowJsonConfig$value=" + this.enableUpdateFlowJsonConfig$value + ", workingDirectory$value=" + this.workingDirectory$value + ", switchers$value=" + this.switchers$value + ", systemSwitchers$value=" + this.systemSwitchers$value + ", projectConfiguration=" + this.projectConfiguration + ")";
        }
    }
}

