/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.mia.model.configuration.ProcessMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class ProcessMetaDataConverter
implements AttributeConverter<List<ProcessMetaData>, String> {
    private static final Logger log = LoggerFactory.getLogger(ProcessMetaDataConverter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(List<ProcessMetaData> requestParams) {
        String requestParamsJson = null;
        if (requestParams != null) {
            try {
                requestParamsJson = objectMapper.writeValueAsString(requestParams);
            }
            catch (JsonProcessingException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return requestParamsJson;
    }

    public List<ProcessMetaData> convertToEntityAttribute(String requestParamsJson) {
        List requestParams = null;
        if (Strings.isNotBlank((String)requestParamsJson)) {
            try {
                requestParams = (List)objectMapper.readValue(requestParamsJson, List.class);
            }
            catch (IOException e) {
                log.error("JSON reading error", (Throwable)e);
            }
        }
        return requestParams;
    }
}

