/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.ei;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportCommandPrefix;
import org.qubership.atp.mia.model.ei.ExportImportIdentifier;

public class ExportImportCommonConfiguration
extends ExportImportIdentifier {
    private static final long serialVersionUID = -429059651116173040L;
    private String defaultSystem;
    private boolean useVariablesInsideVariable;
    private String variableFormat;
    private boolean saveFilesToWorkingDir;
    private boolean saveSqlTablesToFile;
    private HashMap<String, String> commonVariables;
    private String nextBillDateSql;
    private String resetCacheSql;
    private String ethalonFilesPath;
    private String externalEnvironmentPrefix;
    private String commandShellSeparator;
    private List<ExportImportCommandPrefix> commandShellPrefixes;
    private String genevaDateMask;
    private String sshRsaFilePath;
    private int linesAmount;

    public ExportImportCommonConfiguration(CommonConfiguration c) {
        super(c.getProjectId(), "CommonConfiguration", c.getProjectId(), c.getProjectId());
        this.defaultSystem = c.getDefaultSystem();
        this.useVariablesInsideVariable = c.isUseVariablesInsideVariable();
        this.variableFormat = c.getVariableFormat();
        this.saveFilesToWorkingDir = c.isSaveFilesToWorkingDir();
        this.saveSqlTablesToFile = c.isSaveSqlTablesToFile();
        this.commonVariables = c.getCommonVariables();
        this.nextBillDateSql = c.getNextBillDateSql();
        this.resetCacheSql = c.getResetCacheSql();
        this.ethalonFilesPath = c.getEthalonFilesPath();
        this.externalEnvironmentPrefix = c.getExternalEnvironmentPrefix();
        this.commandShellSeparator = c.getCommandShellSeparator();
        this.commandShellPrefixes = c.getCommandShellPrefixes().stream().map(ExportImportCommandPrefix::new).collect(Collectors.toList());
        this.genevaDateMask = c.getGenevaDateMask();
        this.sshRsaFilePath = c.getSshRsaFilePath();
        this.linesAmount = c.getLinesAmount();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportImportCommonConfiguration)) {
            return false;
        }
        ExportImportCommonConfiguration other = (ExportImportCommonConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isUseVariablesInsideVariable() != other.isUseVariablesInsideVariable()) {
            return false;
        }
        if (this.isSaveFilesToWorkingDir() != other.isSaveFilesToWorkingDir()) {
            return false;
        }
        if (this.isSaveSqlTablesToFile() != other.isSaveSqlTablesToFile()) {
            return false;
        }
        if (this.getLinesAmount() != other.getLinesAmount()) {
            return false;
        }
        String this$defaultSystem = this.getDefaultSystem();
        String other$defaultSystem = other.getDefaultSystem();
        if (this$defaultSystem == null ? other$defaultSystem != null : !this$defaultSystem.equals(other$defaultSystem)) {
            return false;
        }
        String this$variableFormat = this.getVariableFormat();
        String other$variableFormat = other.getVariableFormat();
        if (this$variableFormat == null ? other$variableFormat != null : !this$variableFormat.equals(other$variableFormat)) {
            return false;
        }
        HashMap<String, String> this$commonVariables = this.getCommonVariables();
        HashMap<String, String> other$commonVariables = other.getCommonVariables();
        if (this$commonVariables == null ? other$commonVariables != null : !((Object)this$commonVariables).equals(other$commonVariables)) {
            return false;
        }
        String this$nextBillDateSql = this.getNextBillDateSql();
        String other$nextBillDateSql = other.getNextBillDateSql();
        if (this$nextBillDateSql == null ? other$nextBillDateSql != null : !this$nextBillDateSql.equals(other$nextBillDateSql)) {
            return false;
        }
        String this$resetCacheSql = this.getResetCacheSql();
        String other$resetCacheSql = other.getResetCacheSql();
        if (this$resetCacheSql == null ? other$resetCacheSql != null : !this$resetCacheSql.equals(other$resetCacheSql)) {
            return false;
        }
        String this$ethalonFilesPath = this.getEthalonFilesPath();
        String other$ethalonFilesPath = other.getEthalonFilesPath();
        if (this$ethalonFilesPath == null ? other$ethalonFilesPath != null : !this$ethalonFilesPath.equals(other$ethalonFilesPath)) {
            return false;
        }
        String this$externalEnvironmentPrefix = this.getExternalEnvironmentPrefix();
        String other$externalEnvironmentPrefix = other.getExternalEnvironmentPrefix();
        if (this$externalEnvironmentPrefix == null ? other$externalEnvironmentPrefix != null : !this$externalEnvironmentPrefix.equals(other$externalEnvironmentPrefix)) {
            return false;
        }
        String this$commandShellSeparator = this.getCommandShellSeparator();
        String other$commandShellSeparator = other.getCommandShellSeparator();
        if (this$commandShellSeparator == null ? other$commandShellSeparator != null : !this$commandShellSeparator.equals(other$commandShellSeparator)) {
            return false;
        }
        List<ExportImportCommandPrefix> this$commandShellPrefixes = this.getCommandShellPrefixes();
        List<ExportImportCommandPrefix> other$commandShellPrefixes = other.getCommandShellPrefixes();
        if (this$commandShellPrefixes == null ? other$commandShellPrefixes != null : !((Object)this$commandShellPrefixes).equals(other$commandShellPrefixes)) {
            return false;
        }
        String this$genevaDateMask = this.getGenevaDateMask();
        String other$genevaDateMask = other.getGenevaDateMask();
        if (this$genevaDateMask == null ? other$genevaDateMask != null : !this$genevaDateMask.equals(other$genevaDateMask)) {
            return false;
        }
        String this$sshRsaFilePath = this.getSshRsaFilePath();
        String other$sshRsaFilePath = other.getSshRsaFilePath();
        return !(this$sshRsaFilePath == null ? other$sshRsaFilePath != null : !this$sshRsaFilePath.equals(other$sshRsaFilePath));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExportImportCommonConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUseVariablesInsideVariable() ? 79 : 97);
        result = result * 59 + (this.isSaveFilesToWorkingDir() ? 79 : 97);
        result = result * 59 + (this.isSaveSqlTablesToFile() ? 79 : 97);
        result = result * 59 + this.getLinesAmount();
        String $defaultSystem = this.getDefaultSystem();
        result = result * 59 + ($defaultSystem == null ? 43 : $defaultSystem.hashCode());
        String $variableFormat = this.getVariableFormat();
        result = result * 59 + ($variableFormat == null ? 43 : $variableFormat.hashCode());
        HashMap<String, String> $commonVariables = this.getCommonVariables();
        result = result * 59 + ($commonVariables == null ? 43 : ((Object)$commonVariables).hashCode());
        String $nextBillDateSql = this.getNextBillDateSql();
        result = result * 59 + ($nextBillDateSql == null ? 43 : $nextBillDateSql.hashCode());
        String $resetCacheSql = this.getResetCacheSql();
        result = result * 59 + ($resetCacheSql == null ? 43 : $resetCacheSql.hashCode());
        String $ethalonFilesPath = this.getEthalonFilesPath();
        result = result * 59 + ($ethalonFilesPath == null ? 43 : $ethalonFilesPath.hashCode());
        String $externalEnvironmentPrefix = this.getExternalEnvironmentPrefix();
        result = result * 59 + ($externalEnvironmentPrefix == null ? 43 : $externalEnvironmentPrefix.hashCode());
        String $commandShellSeparator = this.getCommandShellSeparator();
        result = result * 59 + ($commandShellSeparator == null ? 43 : $commandShellSeparator.hashCode());
        List<ExportImportCommandPrefix> $commandShellPrefixes = this.getCommandShellPrefixes();
        result = result * 59 + ($commandShellPrefixes == null ? 43 : ((Object)$commandShellPrefixes).hashCode());
        String $genevaDateMask = this.getGenevaDateMask();
        result = result * 59 + ($genevaDateMask == null ? 43 : $genevaDateMask.hashCode());
        String $sshRsaFilePath = this.getSshRsaFilePath();
        result = result * 59 + ($sshRsaFilePath == null ? 43 : $sshRsaFilePath.hashCode());
        return result;
    }

    public ExportImportCommonConfiguration() {
    }

    @Override
    public String toString() {
        return "ExportImportCommonConfiguration(super=" + super.toString() + ", defaultSystem=" + this.getDefaultSystem() + ", useVariablesInsideVariable=" + this.isUseVariablesInsideVariable() + ", variableFormat=" + this.getVariableFormat() + ", saveFilesToWorkingDir=" + this.isSaveFilesToWorkingDir() + ", saveSqlTablesToFile=" + this.isSaveSqlTablesToFile() + ", commonVariables=" + this.getCommonVariables() + ", nextBillDateSql=" + this.getNextBillDateSql() + ", resetCacheSql=" + this.getResetCacheSql() + ", ethalonFilesPath=" + this.getEthalonFilesPath() + ", externalEnvironmentPrefix=" + this.getExternalEnvironmentPrefix() + ", commandShellSeparator=" + this.getCommandShellSeparator() + ", commandShellPrefixes=" + this.getCommandShellPrefixes() + ", genevaDateMask=" + this.getGenevaDateMask() + ", sshRsaFilePath=" + this.getSshRsaFilePath() + ", linesAmount=" + this.getLinesAmount() + ")";
    }

    public String getDefaultSystem() {
        return this.defaultSystem;
    }

    public boolean isUseVariablesInsideVariable() {
        return this.useVariablesInsideVariable;
    }

    public String getVariableFormat() {
        return this.variableFormat;
    }

    public boolean isSaveFilesToWorkingDir() {
        return this.saveFilesToWorkingDir;
    }

    public boolean isSaveSqlTablesToFile() {
        return this.saveSqlTablesToFile;
    }

    public HashMap<String, String> getCommonVariables() {
        return this.commonVariables;
    }

    public String getNextBillDateSql() {
        return this.nextBillDateSql;
    }

    public String getResetCacheSql() {
        return this.resetCacheSql;
    }

    public String getEthalonFilesPath() {
        return this.ethalonFilesPath;
    }

    public String getExternalEnvironmentPrefix() {
        return this.externalEnvironmentPrefix;
    }

    public String getCommandShellSeparator() {
        return this.commandShellSeparator;
    }

    public List<ExportImportCommandPrefix> getCommandShellPrefixes() {
        return this.commandShellPrefixes;
    }

    public String getGenevaDateMask() {
        return this.genevaDateMask;
    }

    public String getSshRsaFilePath() {
        return this.sshRsaFilePath;
    }

    public int getLinesAmount() {
        return this.linesAmount;
    }
}

