/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.ei;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportIdentifier;
import org.qubership.atp.mia.model.impl.executable.ProcessSettings;

public class ExportImportProcess
extends ExportImportIdentifier {
    private static final long serialVersionUID = 5179060695381416613L;
    private List<UUID> inCompounds;
    private List<UUID> inSections;
    private ProcessSettings processSettings;

    public ExportImportProcess(ProcessConfiguration p) {
        super(p.getId(), p.getName(), p.getProjectConfiguration().getProjectId(), p.getSourceId());
        this.processSettings = p.getProcessSettings();
        if (p.getInSections() != null) {
            this.inSections = p.getInSections().stream().filter(Objects::nonNull).map(SectionConfiguration::getId).collect(Collectors.toList());
        }
        if (p.getInCompounds() != null) {
            this.inCompounds = p.getInCompounds().stream().filter(Objects::nonNull).map(CompoundConfiguration::getId).collect(Collectors.toList());
        }
    }

    public List<UUID> getInCompounds() {
        return this.inCompounds;
    }

    public List<UUID> getInSections() {
        return this.inSections;
    }

    public ProcessSettings getProcessSettings() {
        return this.processSettings;
    }

    public void setInCompounds(List<UUID> inCompounds) {
        this.inCompounds = inCompounds;
    }

    public void setInSections(List<UUID> inSections) {
        this.inSections = inSections;
    }

    public void setProcessSettings(ProcessSettings processSettings) {
        this.processSettings = processSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportImportProcess)) {
            return false;
        }
        ExportImportProcess other = (ExportImportProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<UUID> this$inCompounds = this.getInCompounds();
        List<UUID> other$inCompounds = other.getInCompounds();
        if (this$inCompounds == null ? other$inCompounds != null : !((Object)this$inCompounds).equals(other$inCompounds)) {
            return false;
        }
        List<UUID> this$inSections = this.getInSections();
        List<UUID> other$inSections = other.getInSections();
        if (this$inSections == null ? other$inSections != null : !((Object)this$inSections).equals(other$inSections)) {
            return false;
        }
        ProcessSettings this$processSettings = this.getProcessSettings();
        ProcessSettings other$processSettings = other.getProcessSettings();
        return !(this$processSettings == null ? other$processSettings != null : !((Object)this$processSettings).equals(other$processSettings));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExportImportProcess;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<UUID> $inCompounds = this.getInCompounds();
        result = result * 59 + ($inCompounds == null ? 43 : ((Object)$inCompounds).hashCode());
        List<UUID> $inSections = this.getInSections();
        result = result * 59 + ($inSections == null ? 43 : ((Object)$inSections).hashCode());
        ProcessSettings $processSettings = this.getProcessSettings();
        result = result * 59 + ($processSettings == null ? 43 : ((Object)$processSettings).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExportImportProcess(super=" + super.toString() + ", inCompounds=" + this.getInCompounds() + ", inSections=" + this.getInSections() + ", processSettings=" + this.getProcessSettings() + ")";
    }

    public ExportImportProcess() {
    }
}

