/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.environment;

import java.util.Objects;
import java.util.StringJoiner;
import org.qubership.atp.mia.model.environment.Server;

public class ConnectionProps {
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;
    private final String key;
    private final String passphrase;
    private final boolean pty;
    private final int timeoutConnect;
    private final int timeoutExecute;
    private final long timeOutFileDownload;
    private final int channelsPerSession;
    private final String sshServerKexAlgorithms;

    public ConnectionProps(String hostname, Integer port, String username, String password, String key, String passphrase, boolean pty, int timeoutConnect, int timeoutExecute, long timeOutFileDownload, int channelsPerSession, String sshServerKexAlgorithms) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.key = key;
        this.passphrase = passphrase;
        this.pty = pty;
        this.timeoutConnect = timeoutConnect;
        this.timeoutExecute = timeoutExecute;
        this.timeOutFileDownload = timeOutFileDownload;
        this.channelsPerSession = channelsPerSession;
        this.sshServerKexAlgorithms = sshServerKexAlgorithms;
    }

    public static ConnectionProps forSsh(Server server) {
        return new ConnectionProps(server.getHost(), server.getPort(), server.getUser(), server.getPass(), server.getKey(), server.getPassPhrase(), server.getPty(), server.getTimeoutConnect(), server.getTimeoutExecute(), server.getTimeOutFileDownload(), server.getChannelsPerSession(), server.getSshServerKexAlgorithms());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionProps that = (ConnectionProps)o;
        return Objects.equals(this.hostname, that.hostname) && Objects.equals(this.port, that.port) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.passphrase, that.passphrase) && Objects.equals(this.key, that.key) && Objects.equals(this.pty, that.pty);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.port, this.username, this.password, this.passphrase, this.key, this.pty);
    }

    public String toString() {
        return new StringJoiner(", ", "[", "]").add("hostname='" + this.hostname + "'").add("port='" + this.port + "'").add("username='" + this.username + "'").toString();
    }

    public String fullInfo() {
        return new StringJoiner(", ", "[", "]").add("hostname='" + this.hostname + "'").add("port='" + this.port + "'").add("username='" + this.username + "'").add("pty=" + this.pty).add("timeoutConnect=" + this.timeoutConnect).add("timeoutExecute=" + this.timeoutExecute).toString();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKey() {
        return this.key;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean isPty() {
        return this.pty;
    }

    public int getTimeoutConnect() {
        return this.timeoutConnect;
    }

    public int getTimeoutExecute() {
        return this.timeoutExecute;
    }

    public long getTimeOutFileDownload() {
        return this.timeOutFileDownload;
    }

    public int getChannelsPerSession() {
        return this.channelsPerSession;
    }

    public String getSshServerKexAlgorithms() {
        return this.sshServerKexAlgorithms;
    }
}

