/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.environment;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.EnvSystemNotFoundInContextException;
import org.qubership.atp.mia.model.environment.AbstractConfiguratorModel;
import org.qubership.atp.mia.model.environment.System;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment
extends AbstractConfiguratorModel {
    private static final Logger log = LoggerFactory.getLogger(Environment.class);
    private UUID projectId;
    private List<System> systems;

    public System getSystem(String sysName) {
        Optional<System> system;
        if (!Strings.isNullOrEmpty((String)sysName) && (system = this.systems.stream().filter(sys -> sysName.equals(sys.getName())).findFirst()).isPresent()) {
            return system.get();
        }
        throw new EnvSystemNotFoundInContextException(sysName);
    }

    protected Environment(EnvironmentBuilder<?, ?> b) {
        super(b);
        this.projectId = ((EnvironmentBuilder)b).projectId;
        this.systems = ((EnvironmentBuilder)b).systems;
    }

    public static EnvironmentBuilder<?, ?> builder() {
        return new EnvironmentBuilderImpl();
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public List<System> getSystems() {
        return this.systems;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setSystems(List<System> systems) {
        this.systems = systems;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        List<System> this$systems = this.getSystems();
        List<System> other$systems = other.getSystems();
        return !(this$systems == null ? other$systems != null : !((Object)this$systems).equals(other$systems));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        List<System> $systems = this.getSystems();
        result = result * 59 + ($systems == null ? 43 : ((Object)$systems).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Environment(projectId=" + this.getProjectId() + ", systems=" + this.getSystems() + ")";
    }

    public Environment() {
    }

    public static abstract class EnvironmentBuilder<C extends Environment, B extends EnvironmentBuilder<C, B>>
    extends AbstractConfiguratorModel.AbstractConfiguratorModelBuilder<C, B> {
        private UUID projectId;
        private List<System> systems;

        public B projectId(UUID projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        public B systems(List<System> systems) {
            this.systems = systems;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Environment.EnvironmentBuilder(super=" + super.toString() + ", projectId=" + this.projectId + ", systems=" + this.systems + ")";
        }
    }

    private static final class EnvironmentBuilderImpl
    extends EnvironmentBuilder<Environment, EnvironmentBuilderImpl> {
        private EnvironmentBuilderImpl() {
        }

        @Override
        protected EnvironmentBuilderImpl self() {
            return this;
        }

        @Override
        public Environment build() {
            return new Environment(this);
        }
    }
}

