/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.file;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.file.ProjectFile;

@Entity
@Table(name="project_directory")
public class ProjectDirectory
extends DateAuditorEntity {
    private static final long serialVersionUID = -1184948591984244690L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    protected UUID id;
    @Column(name="source_id")
    private UUID sourceId;
    @Column(name="directory_name")
    @DiffInclude
    private String name;
    @ManyToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="parent_id", referencedColumnName="id")
    @DiffInclude
    private ProjectDirectory parentDirectory;
    @OneToMany(mappedBy="parentDirectory", targetEntity=ProjectDirectory.class, cascade={CascadeType.ALL})
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<ProjectDirectory> directories;
    @ManyToOne(targetEntity=ProjectConfiguration.class)
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;
    @OneToMany(mappedBy="directory", targetEntity=ProjectFile.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<ProjectFile> files;

    public List<UUID> getChildrenUuid() {
        ArrayList<UUID> childsUuid = new ArrayList<UUID>();
        this.directories.forEach(s -> {
            childsUuid.add(s.getId());
            childsUuid.addAll(s.getChildrenUuid());
        });
        return childsUuid;
    }

    public List<String> getChildrenNames() {
        ArrayList<String> childsNames = new ArrayList<String>();
        this.directories.forEach(s -> {
            childsNames.add(s.getName());
            childsNames.addAll(s.getChildrenNames());
        });
        return childsNames;
    }

    public List<String> getFilesNames() {
        ArrayList<String> filesNames = new ArrayList<String>();
        this.files.forEach(s -> filesNames.add(s.getName()));
        return filesNames;
    }

    public Path getPathDirectory() {
        Path path = Paths.get("", new String[0]);
        if (this.getParentDirectory() != null) {
            path = this.getParentDirectory().getPathDirectory();
        }
        path = path.resolve(this.getName());
        return path;
    }

    public List<ProjectDirectory> getWithChildrenDirectories() {
        ArrayList<ProjectDirectory> dirs = new ArrayList<ProjectDirectory>();
        this.directories.forEach(d -> {
            dirs.add((ProjectDirectory)d);
            dirs.addAll(d.getWithChildrenDirectories());
        });
        return dirs;
    }

    private static List<ProjectDirectory> $default$directories() {
        return new ArrayList<ProjectDirectory>();
    }

    private static List<ProjectFile> $default$files() {
        return new ArrayList<ProjectFile>();
    }

    protected ProjectDirectory(ProjectDirectoryBuilder<?, ?> b) {
        super(b);
        this.id = ((ProjectDirectoryBuilder)b).id;
        this.sourceId = ((ProjectDirectoryBuilder)b).sourceId;
        this.name = ((ProjectDirectoryBuilder)b).name;
        this.parentDirectory = ((ProjectDirectoryBuilder)b).parentDirectory;
        this.directories = ((ProjectDirectoryBuilder)b).directories$set ? ((ProjectDirectoryBuilder)b).directories$value : ProjectDirectory.$default$directories();
        this.projectConfiguration = ((ProjectDirectoryBuilder)b).projectConfiguration;
        this.files = ((ProjectDirectoryBuilder)b).files$set ? ((ProjectDirectoryBuilder)b).files$value : ProjectDirectory.$default$files();
    }

    public static ProjectDirectoryBuilder<?, ?> builder() {
        return new ProjectDirectoryBuilderImpl();
    }

    public ProjectDirectoryBuilder<?, ?> toBuilder() {
        return new ProjectDirectoryBuilderImpl().$fillValuesFrom(this);
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.name;
    }

    public ProjectDirectory getParentDirectory() {
        return this.parentDirectory;
    }

    public List<ProjectDirectory> getDirectories() {
        return this.directories;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public List<ProjectFile> getFiles() {
        return this.files;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentDirectory(ProjectDirectory parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public void setDirectories(List<ProjectDirectory> directories) {
        this.directories = directories;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    public void setFiles(List<ProjectFile> files) {
        this.files = files;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectDirectory)) {
            return false;
        }
        ProjectDirectory other = (ProjectDirectory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$sourceId = this.getSourceId();
        UUID other$sourceId = other.getSourceId();
        return !(this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectDirectory;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectDirectory(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", name=" + this.getName() + ", directories=" + this.getDirectories() + ", files=" + this.getFiles() + ")";
    }

    public ProjectDirectory(UUID id, UUID sourceId, String name, ProjectDirectory parentDirectory, List<ProjectDirectory> directories, ProjectConfiguration projectConfiguration, List<ProjectFile> files) {
        this.id = id;
        this.sourceId = sourceId;
        this.name = name;
        this.parentDirectory = parentDirectory;
        this.directories = directories;
        this.projectConfiguration = projectConfiguration;
        this.files = files;
    }

    public ProjectDirectory() {
        this.directories = ProjectDirectory.$default$directories();
        this.files = ProjectDirectory.$default$files();
    }

    public static abstract class ProjectDirectoryBuilder<C extends ProjectDirectory, B extends ProjectDirectoryBuilder<C, B>>
    extends DateAuditorEntity.DateAuditorEntityBuilder<C, B> {
        private UUID id;
        private UUID sourceId;
        private String name;
        private ProjectDirectory parentDirectory;
        private boolean directories$set;
        private List<ProjectDirectory> directories$value;
        private ProjectConfiguration projectConfiguration;
        private boolean files$set;
        private List<ProjectFile> files$value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ProjectDirectoryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ProjectDirectory instance, ProjectDirectoryBuilder<?, ?> b) {
            b.id(instance.id);
            b.sourceId(instance.sourceId);
            b.name(instance.name);
            b.parentDirectory(instance.parentDirectory);
            b.directories(instance.directories);
            b.projectConfiguration(instance.projectConfiguration);
            b.files(instance.files);
        }

        public B id(UUID id) {
            this.id = id;
            return (B)this.self();
        }

        public B sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B parentDirectory(ProjectDirectory parentDirectory) {
            this.parentDirectory = parentDirectory;
            return (B)this.self();
        }

        public B directories(List<ProjectDirectory> directories) {
            this.directories$value = directories;
            this.directories$set = true;
            return (B)this.self();
        }

        public B projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return (B)this.self();
        }

        public B files(List<ProjectFile> files) {
            this.files$value = files;
            this.files$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ProjectDirectory.ProjectDirectoryBuilder(super=" + super.toString() + ", id=" + this.id + ", sourceId=" + this.sourceId + ", name=" + this.name + ", parentDirectory=" + this.parentDirectory + ", directories$value=" + this.directories$value + ", projectConfiguration=" + this.projectConfiguration + ", files$value=" + this.files$value + ")";
        }
    }

    private static final class ProjectDirectoryBuilderImpl
    extends ProjectDirectoryBuilder<ProjectDirectory, ProjectDirectoryBuilderImpl> {
        private ProjectDirectoryBuilderImpl() {
        }

        @Override
        protected ProjectDirectoryBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectDirectory build() {
            return new ProjectDirectory(this);
        }
    }
}

