/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.file;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.file.ProjectDirectory;

@Entity
@Table(name="project_file")
public class ProjectFile
extends DateAuditorEntity {
    private static final long serialVersionUID = 8428162091529756975L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private UUID id;
    @Column(name="source_id")
    private UUID sourceId;
    @Column(name="file_name")
    @DiffInclude
    private String name;
    @Column(name="gridfs_object_id")
    private String gridFsObjectId;
    @Column(name="last_update_when")
    private LocalDateTime lastUpdateWhen;
    @Column(name="last_update_by")
    private String lastUpdateBy;
    @Column(name="size")
    @DiffInclude
    private Long size;
    @ManyToOne(targetEntity=ProjectDirectory.class)
    @JoinColumn(name="directory_id")
    @DiffInclude
    private ProjectDirectory directory;
    @ManyToOne(targetEntity=ProjectConfiguration.class)
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;

    public Path getPathFile() {
        Path pathFile = Paths.get("", new String[0]);
        if (this.directory != null) {
            pathFile = pathFile.resolve(this.directory.getPathDirectory());
        }
        return pathFile.resolve(this.name);
    }

    protected ProjectFile(ProjectFileBuilder<?, ?> b) {
        super(b);
        this.id = ((ProjectFileBuilder)b).id;
        this.sourceId = ((ProjectFileBuilder)b).sourceId;
        this.name = ((ProjectFileBuilder)b).name;
        this.gridFsObjectId = ((ProjectFileBuilder)b).gridFsObjectId;
        this.lastUpdateWhen = ((ProjectFileBuilder)b).lastUpdateWhen;
        this.lastUpdateBy = ((ProjectFileBuilder)b).lastUpdateBy;
        this.size = ((ProjectFileBuilder)b).size;
        this.directory = ((ProjectFileBuilder)b).directory;
        this.projectConfiguration = ((ProjectFileBuilder)b).projectConfiguration;
    }

    public static ProjectFileBuilder<?, ?> builder() {
        return new ProjectFileBuilderImpl();
    }

    public ProjectFileBuilder<?, ?> toBuilder() {
        return new ProjectFileBuilderImpl().$fillValuesFrom(this);
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getGridFsObjectId() {
        return this.gridFsObjectId;
    }

    public LocalDateTime getLastUpdateWhen() {
        return this.lastUpdateWhen;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public Long getSize() {
        return this.size;
    }

    public ProjectDirectory getDirectory() {
        return this.directory;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGridFsObjectId(String gridFsObjectId) {
        this.gridFsObjectId = gridFsObjectId;
    }

    public void setLastUpdateWhen(LocalDateTime lastUpdateWhen) {
        this.lastUpdateWhen = lastUpdateWhen;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setDirectory(ProjectDirectory directory) {
        this.directory = directory;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectFile)) {
            return false;
        }
        ProjectFile other = (ProjectFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$sourceId = this.getSourceId();
        UUID other$sourceId = other.getSourceId();
        return !(this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectFile(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", name=" + this.getName() + ", gridFsObjectId=" + this.getGridFsObjectId() + ", lastUpdateWhen=" + this.getLastUpdateWhen() + ", lastUpdateBy=" + this.getLastUpdateBy() + ", size=" + this.getSize() + ")";
    }

    public ProjectFile(UUID id, UUID sourceId, String name, String gridFsObjectId, LocalDateTime lastUpdateWhen, String lastUpdateBy, Long size, ProjectDirectory directory, ProjectConfiguration projectConfiguration) {
        this.id = id;
        this.sourceId = sourceId;
        this.name = name;
        this.gridFsObjectId = gridFsObjectId;
        this.lastUpdateWhen = lastUpdateWhen;
        this.lastUpdateBy = lastUpdateBy;
        this.size = size;
        this.directory = directory;
        this.projectConfiguration = projectConfiguration;
    }

    public ProjectFile() {
    }

    public static abstract class ProjectFileBuilder<C extends ProjectFile, B extends ProjectFileBuilder<C, B>>
    extends DateAuditorEntity.DateAuditorEntityBuilder<C, B> {
        private UUID id;
        private UUID sourceId;
        private String name;
        private String gridFsObjectId;
        private LocalDateTime lastUpdateWhen;
        private String lastUpdateBy;
        private Long size;
        private ProjectDirectory directory;
        private ProjectConfiguration projectConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ProjectFileBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ProjectFile instance, ProjectFileBuilder<?, ?> b) {
            b.id(instance.id);
            b.sourceId(instance.sourceId);
            b.name(instance.name);
            b.gridFsObjectId(instance.gridFsObjectId);
            b.lastUpdateWhen(instance.lastUpdateWhen);
            b.lastUpdateBy(instance.lastUpdateBy);
            b.size(instance.size);
            b.directory(instance.directory);
            b.projectConfiguration(instance.projectConfiguration);
        }

        public B id(UUID id) {
            this.id = id;
            return (B)this.self();
        }

        public B sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B gridFsObjectId(String gridFsObjectId) {
            this.gridFsObjectId = gridFsObjectId;
            return (B)this.self();
        }

        public B lastUpdateWhen(LocalDateTime lastUpdateWhen) {
            this.lastUpdateWhen = lastUpdateWhen;
            return (B)this.self();
        }

        public B lastUpdateBy(String lastUpdateBy) {
            this.lastUpdateBy = lastUpdateBy;
            return (B)this.self();
        }

        public B size(Long size) {
            this.size = size;
            return (B)this.self();
        }

        public B directory(ProjectDirectory directory) {
            this.directory = directory;
            return (B)this.self();
        }

        public B projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ProjectFile.ProjectFileBuilder(super=" + super.toString() + ", id=" + this.id + ", sourceId=" + this.sourceId + ", name=" + this.name + ", gridFsObjectId=" + this.gridFsObjectId + ", lastUpdateWhen=" + this.lastUpdateWhen + ", lastUpdateBy=" + this.lastUpdateBy + ", size=" + this.size + ", directory=" + this.directory + ", projectConfiguration=" + this.projectConfiguration + ")";
        }
    }

    private static final class ProjectFileBuilderImpl
    extends ProjectFileBuilder<ProjectFile, ProjectFileBuilderImpl> {
        private ProjectFileBuilderImpl() {
        }

        @Override
        protected ProjectFileBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectFile build() {
            return new ProjectFile(this);
        }
    }
}

