/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.qubership.atp.mia.exceptions.runtimeerrors.UnsupportedCommandTypeException;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.model.impl.output.HtmlPage;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandResponse {
    private static final Logger log = LoggerFactory.getLogger(CommandResponse.class);
    private CommandResponseType type;
    private String command = "";
    private Map<String, String> connectionInfo = new HashMap<String, String>();
    private LinkedList<CommandOutput> commandOutputs;
    private SqlResponse sqlResponse;
    private HtmlPage htmlPage;
    private LinkedList<String> description;
    private LinkedList<Exception> errors;
    private boolean checkStatusCodeFlag;
    private String statusCode;
    private List<String> expectedCodes;
    private String postScriptExecutionReport;

    public CommandResponse() {
    }

    public CommandResponse(SqlResponse sqlResponse) {
        this.sqlResponse = sqlResponse;
    }

    public CommandResponse(LinkedList<CommandOutput> commandOutputs) {
        this.commandOutputs = commandOutputs;
    }

    public CommandResponse(CommandOutput commandOutput) {
        this.addCommandOutput(commandOutput);
    }

    public CommandResponse(HtmlPage htmlPage) {
        this.htmlPage = htmlPage;
    }

    public static String getConnectionNameFromResponseType(CommandResponseType type) {
        switch (type.ordinal()) {
            case 1: {
                return "SSH";
            }
            case 2: {
                return "DB";
            }
            case 0: {
                return "HTTP";
            }
            case 3: {
                return "NO_SYSTEM_REQUIRED";
            }
        }
        throw new UnsupportedCommandTypeException(type);
    }

    public static CommandResponse getCommandResponseWithFilledRequestInfo() {
        CommandResponse commandResponse = new CommandResponse();
        String notificationUser = "For REST_FROM_TEST_DATA please reference the excel file for a connection information";
        HashMap<String, String> connectionInfo = new HashMap<String, String>(){
            {
                this.put("bodyRequest", "For REST_FROM_TEST_DATA please reference the excel file for a connection information");
                this.put("timestampRequest", Utils.getTimestamp());
                this.put("timestampResponse", Utils.getTimestamp());
            }
        };
        commandResponse.setConnectionInfo((Map<String, String>)connectionInfo);
        return commandResponse;
    }

    public void addCommandResponse(CommandResponse commandResponse) {
        this.command = this.command + (this.command.isEmpty() ? "" : "\n\n");
        this.command = this.command + commandResponse.command;
        this.connectionInfo.putAll(commandResponse.getConnectionInfo());
        this.addCommandOutputs(commandResponse.getCommandOutputs());
        this.addErrors(commandResponse.getErrors());
    }

    public void addLog(CommandOutput commandOutput) {
        this.createCommandOutputs();
        this.commandOutputs.add(0, commandOutput);
    }

    public void addCommandOutput(CommandOutput commandOutput) {
        this.createCommandOutputs();
        this.commandOutputs.add(commandOutput);
    }

    public void concatCommandOutput(CommandOutput commandOutput) {
        this.createCommandOutputs();
        if (this.commandOutputs.isEmpty()) {
            this.commandOutputs.add(commandOutput);
        } else {
            this.commandOutputs.getFirst().concatContent(commandOutput);
        }
    }

    public void addCommandOutputs(LinkedList<CommandOutput> commandOutputs) {
        if (commandOutputs != null) {
            this.createCommandOutputs();
            this.commandOutputs.addAll(commandOutputs);
        }
    }

    public void addDescription(String description) {
        this.createDescription();
        this.description.add(description);
    }

    public void addError(Exception e) {
        this.createErrors();
        this.errors.add(e);
    }

    public void addErrors(LinkedList<Exception> e) {
        if (e != null) {
            this.createErrors();
            this.errors.addAll(e);
        }
    }

    private void createDescription() {
        if (this.description == null) {
            this.description = new LinkedList();
        }
    }

    private void createErrors() {
        if (this.errors == null) {
            this.errors = new LinkedList();
        }
    }

    private void createCommandOutputs() {
        if (this.commandOutputs == null) {
            this.commandOutputs = new LinkedList();
        }
    }

    public CommandResponseType getType() {
        return this.type;
    }

    public String getCommand() {
        return this.command;
    }

    public Map<String, String> getConnectionInfo() {
        return this.connectionInfo;
    }

    public LinkedList<CommandOutput> getCommandOutputs() {
        return this.commandOutputs;
    }

    public SqlResponse getSqlResponse() {
        return this.sqlResponse;
    }

    public HtmlPage getHtmlPage() {
        return this.htmlPage;
    }

    public LinkedList<String> getDescription() {
        return this.description;
    }

    public LinkedList<Exception> getErrors() {
        return this.errors;
    }

    public boolean isCheckStatusCodeFlag() {
        return this.checkStatusCodeFlag;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public List<String> getExpectedCodes() {
        return this.expectedCodes;
    }

    public String getPostScriptExecutionReport() {
        return this.postScriptExecutionReport;
    }

    public void setType(CommandResponseType type) {
        this.type = type;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setConnectionInfo(Map<String, String> connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public void setCommandOutputs(LinkedList<CommandOutput> commandOutputs) {
        this.commandOutputs = commandOutputs;
    }

    public void setSqlResponse(SqlResponse sqlResponse) {
        this.sqlResponse = sqlResponse;
    }

    public void setHtmlPage(HtmlPage htmlPage) {
        this.htmlPage = htmlPage;
    }

    public void setDescription(LinkedList<String> description) {
        this.description = description;
    }

    public void setErrors(LinkedList<Exception> errors) {
        this.errors = errors;
    }

    public void setCheckStatusCodeFlag(boolean checkStatusCodeFlag) {
        this.checkStatusCodeFlag = checkStatusCodeFlag;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setExpectedCodes(List<String> expectedCodes) {
        this.expectedCodes = expectedCodes;
    }

    public void setPostScriptExecutionReport(String postScriptExecutionReport) {
        this.postScriptExecutionReport = postScriptExecutionReport;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandResponse)) {
            return false;
        }
        CommandResponse other = (CommandResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCheckStatusCodeFlag() != other.isCheckStatusCodeFlag()) {
            return false;
        }
        CommandResponseType this$type = this.getType();
        CommandResponseType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Map<String, String> this$connectionInfo = this.getConnectionInfo();
        Map<String, String> other$connectionInfo = other.getConnectionInfo();
        if (this$connectionInfo == null ? other$connectionInfo != null : !((Object)this$connectionInfo).equals(other$connectionInfo)) {
            return false;
        }
        LinkedList<CommandOutput> this$commandOutputs = this.getCommandOutputs();
        LinkedList<CommandOutput> other$commandOutputs = other.getCommandOutputs();
        if (this$commandOutputs == null ? other$commandOutputs != null : !((Object)this$commandOutputs).equals(other$commandOutputs)) {
            return false;
        }
        SqlResponse this$sqlResponse = this.getSqlResponse();
        SqlResponse other$sqlResponse = other.getSqlResponse();
        if (this$sqlResponse == null ? other$sqlResponse != null : !((Object)this$sqlResponse).equals(other$sqlResponse)) {
            return false;
        }
        HtmlPage this$htmlPage = this.getHtmlPage();
        HtmlPage other$htmlPage = other.getHtmlPage();
        if (this$htmlPage == null ? other$htmlPage != null : !((Object)this$htmlPage).equals(other$htmlPage)) {
            return false;
        }
        LinkedList<String> this$description = this.getDescription();
        LinkedList<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        LinkedList<Exception> this$errors = this.getErrors();
        LinkedList<Exception> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        String this$statusCode = this.getStatusCode();
        String other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        List<String> this$expectedCodes = this.getExpectedCodes();
        List<String> other$expectedCodes = other.getExpectedCodes();
        if (this$expectedCodes == null ? other$expectedCodes != null : !((Object)this$expectedCodes).equals(other$expectedCodes)) {
            return false;
        }
        String this$postScriptExecutionReport = this.getPostScriptExecutionReport();
        String other$postScriptExecutionReport = other.getPostScriptExecutionReport();
        return !(this$postScriptExecutionReport == null ? other$postScriptExecutionReport != null : !this$postScriptExecutionReport.equals(other$postScriptExecutionReport));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckStatusCodeFlag() ? 79 : 97);
        CommandResponseType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Map<String, String> $connectionInfo = this.getConnectionInfo();
        result = result * 59 + ($connectionInfo == null ? 43 : ((Object)$connectionInfo).hashCode());
        LinkedList<CommandOutput> $commandOutputs = this.getCommandOutputs();
        result = result * 59 + ($commandOutputs == null ? 43 : ((Object)$commandOutputs).hashCode());
        SqlResponse $sqlResponse = this.getSqlResponse();
        result = result * 59 + ($sqlResponse == null ? 43 : ((Object)$sqlResponse).hashCode());
        HtmlPage $htmlPage = this.getHtmlPage();
        result = result * 59 + ($htmlPage == null ? 43 : ((Object)$htmlPage).hashCode());
        LinkedList<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        LinkedList<Exception> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        String $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        List<String> $expectedCodes = this.getExpectedCodes();
        result = result * 59 + ($expectedCodes == null ? 43 : ((Object)$expectedCodes).hashCode());
        String $postScriptExecutionReport = this.getPostScriptExecutionReport();
        result = result * 59 + ($postScriptExecutionReport == null ? 43 : $postScriptExecutionReport.hashCode());
        return result;
    }

    public String toString() {
        return "CommandResponse(type=" + (Object)((Object)this.getType()) + ", command=" + this.getCommand() + ", connectionInfo=" + this.getConnectionInfo() + ", commandOutputs=" + this.getCommandOutputs() + ", sqlResponse=" + this.getSqlResponse() + ", htmlPage=" + this.getHtmlPage() + ", description=" + this.getDescription() + ", errors=" + this.getErrors() + ", checkStatusCodeFlag=" + this.isCheckStatusCodeFlag() + ", statusCode=" + this.getStatusCode() + ", expectedCodes=" + this.getExpectedCodes() + ", postScriptExecutionReport=" + this.getPostScriptExecutionReport() + ")";
    }

    public static enum CommandResponseType {
        REST,
        SSH,
        SQL,
        NO_SYSTEM_REQUIRED;

    }
}

