/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.mia.model.Constants;
import org.qubership.atp.mia.model.environment.Environment;
import org.qubership.atp.mia.model.environment.System;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbook;
import org.qubership.atp.mia.service.MiaContext;

public class FlowData {
    private UUID projectId;
    private String projectName;
    private UUID sessionId;
    private Map<String, String> parameters = new HashMap<String, String>();
    private TestDataWorkbook testDataWorkbook;
    private Environment environment;

    public FlowData(UUID projectId, String projectName, UUID sessionId) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.sessionId = sessionId;
    }

    public String getCustom(Constants.CustomParameters parameter, MiaContext miaContext) {
        if (Strings.isNotBlank((String)this.parameters.get(parameter.toString()))) {
            this.parameters.put(parameter.toString(), miaContext.evaluate(this.parameters.get(parameter.toString())));
        }
        return this.parameters.get(parameter.toString());
    }

    public void addParameters(Map<String, String> parameters) {
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
    }

    public void addParameter(Constants.CustomParameters parameterKey, String parameterValue) {
        this.addParameter(parameterKey.toString(), parameterValue);
    }

    public void addParameter(String parameterKey, String parameterValue) {
        this.parameters.put(parameterKey, parameterValue);
    }

    public void removeParameter(String parameterKey) {
        this.parameters.remove(parameterKey);
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        if (parameters != null) {
            if (this.parameters != null && !this.parameters.isEmpty()) {
                this.parameters.forEach(parameters::putIfAbsent);
            }
            this.parameters = parameters;
        } else {
            this.parameters = new HashMap<String, String>();
        }
    }

    public System getSystem(String systemName) {
        return this.environment.getSystem(systemName);
    }

    public String toString() {
        return "FlowData(projectId=" + this.projectId + ", projectName=" + this.projectName + ", sessionId=" + this.sessionId + ", parameters=" + this.parameters + ", testDataWorkbook=" + this.testDataWorkbook + ", environment=" + this.environment + ")";
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public TestDataWorkbook getTestDataWorkbook() {
        return this.testDataWorkbook;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setSessionId(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public void setTestDataWorkbook(TestDataWorkbook testDataWorkbook) {
        this.testDataWorkbook = testDataWorkbook;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowData)) {
            return false;
        }
        FlowData other = (FlowData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        TestDataWorkbook this$testDataWorkbook = this.getTestDataWorkbook();
        TestDataWorkbook other$testDataWorkbook = other.getTestDataWorkbook();
        if (this$testDataWorkbook == null ? other$testDataWorkbook != null : !((Object)this$testDataWorkbook).equals(other$testDataWorkbook)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        TestDataWorkbook $testDataWorkbook = this.getTestDataWorkbook();
        result = result * 59 + ($testDataWorkbook == null ? 43 : ((Object)$testDataWorkbook).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        return result;
    }

    public FlowData() {
    }
}

