/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl;

import java.util.Arrays;
import org.apache.logging.log4j.util.Strings;

public class VariableFormat {
    public static final String VAR_NAME = "VARIABLE_NAME";
    public static final String DEFAULT_FORMAT = ":VARIABLE_NAME";
    private final String[] split;
    private final String beforeVariableName;
    private final String afterVariableName;
    private final StringBuilder matches = new StringBuilder();

    public VariableFormat(String variableFormat) {
        this.split = variableFormat.split(VAR_NAME);
        this.beforeVariableName = !variableFormat.startsWith(VAR_NAME) ? this.split[0] : "";
        this.afterVariableName = !variableFormat.endsWith(VAR_NAME) ? this.split[this.split.length - 1] : "";
        this.matches.append("[^" + this.beforeVariableName + "]*");
        this.matches.append(this.beforeVariableName);
        if (Strings.isNotBlank((String)this.afterVariableName)) {
            this.matches.append("([^" + this.afterVariableName + "]*)");
        } else {
            this.matches.append("([^\\W]*)");
        }
        this.matches.append(this.afterVariableName);
    }

    public String getVariableAccordingFormat(String variable) {
        return this.beforeVariableName + variable + this.afterVariableName;
    }

    public String[] getSplit() {
        return this.split;
    }

    public String getBeforeVariableName() {
        return this.beforeVariableName;
    }

    public String getAfterVariableName() {
        return this.afterVariableName;
    }

    public StringBuilder getMatches() {
        return this.matches;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableFormat)) {
            return false;
        }
        VariableFormat other = (VariableFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSplit(), other.getSplit())) {
            return false;
        }
        String this$beforeVariableName = this.getBeforeVariableName();
        String other$beforeVariableName = other.getBeforeVariableName();
        if (this$beforeVariableName == null ? other$beforeVariableName != null : !this$beforeVariableName.equals(other$beforeVariableName)) {
            return false;
        }
        String this$afterVariableName = this.getAfterVariableName();
        String other$afterVariableName = other.getAfterVariableName();
        if (this$afterVariableName == null ? other$afterVariableName != null : !this$afterVariableName.equals(other$afterVariableName)) {
            return false;
        }
        StringBuilder this$matches = this.getMatches();
        StringBuilder other$matches = other.getMatches();
        return !(this$matches == null ? other$matches != null : !this$matches.equals(other$matches));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariableFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getSplit());
        String $beforeVariableName = this.getBeforeVariableName();
        result = result * 59 + ($beforeVariableName == null ? 43 : $beforeVariableName.hashCode());
        String $afterVariableName = this.getAfterVariableName();
        result = result * 59 + ($afterVariableName == null ? 43 : $afterVariableName.hashCode());
        StringBuilder $matches = this.getMatches();
        result = result * 59 + ($matches == null ? 43 : $matches.hashCode());
        return result;
    }

    public String toString() {
        return "VariableFormat(split=" + Arrays.deepToString(this.getSplit()) + ", beforeVariableName=" + this.getBeforeVariableName() + ", afterVariableName=" + this.getAfterVariableName() + ", matches=" + this.getMatches() + ")";
    }
}

