/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.event;

import clover.org.apache.commons.lang3.Range;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.qubership.atp.mia.model.impl.event.EventExcelCustomer;
import org.qubership.atp.mia.model.impl.event.EventExcelMetricService;
import org.qubership.atp.mia.utils.ExcelParserHelper;

public class EventExcelProjectFour
extends EventExcelCustomer {
    EventExcelProjectFour(@Nonnull XSSFSheet sheet, @Nullable String scenario, @Nullable String testCase) {
        super(sheet, scenario, testCase);
        this.eventInfoRange = Range.between((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(24));
        this.headerRowRange = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3));
        this.attrNameRowNumber = 2;
        this.identifications = new HashMap();
        this.identifications.put("Priority", false);
        this.identifications.put("TC ID", false);
        this.identifications.put("Scenario", false);
        this.identifications.put("Product", false);
    }

    @Override
    public void parse() throws IllegalArgumentException {
        EventExcelMetricService.metricsAggregateServiceStatic.eventFromExcelCallStarted();
        this.defineCellsWithData("TC ID", this.testCase, "Scenario", this.scenario);
        super.parse();
        EventExcelMetricService.metricsAggregateServiceStatic.eventFromExcelCallStarted();
    }

    @Override
    protected void defineCellsWithData(@Nonnull String parentHeaderName, @Nonnull String parentHeaderValue, @Nonnull String childHeaderName, @Nullable String childHeaderValue) {
        parentHeaderValue = Strings.isNullOrEmpty((String)parentHeaderValue) ? ".+?" : parentHeaderValue;
        int parentColumn = ExcelParserHelper.getHeaderByPattern(parentHeaderName, (Range<Integer>)this.headerRowRange, this.sheet).getColumnIndex();
        Set<XSSFCell> parentCells = ExcelParserHelper.getAllCellsByPatternFromRow(parentHeaderValue, parentColumn, (Integer)this.headerRowRange.getMaximum() + 1, this.sheet);
        if (!Strings.isNullOrEmpty((String)childHeaderValue)) {
            XSSFCell childCell = ExcelParserHelper.getHeaderByPattern(childHeaderName, (Range<Integer>)this.headerRowRange, this.sheet);
            parentCells.forEach(caseRowCell -> this.cellsWithData.addAll(ExcelParserHelper.getAllCellsByPatternInRange(childHeaderValue, childCell.getColumnIndex(), ExcelParserHelper.getCellColumnRange(caseRowCell), this.sheet)));
        } else {
            this.cellsWithData.addAll(parentCells);
        }
    }
}

